-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: tokenstrings.p
-- Author: Andy Lowry
-- SCCS Info: @(#)tokenstrings.p	1.2 3/13/90

-- This process takes a list of tokens and returns a corresponding
-- list of strings derived from the tokens as follows:
--   * A word token contributes the word string
--   * A delimiter token contributes a one-character string containing
--   the delimiter character
--   * A quoted string token contributes the quoted text, without
--   opening or closing quote characters
--   * A bracketed string token contrinbutes the bracketed text,
--   without the opening or closing bracket characters

tokenSTrings: using (tokenize)

process (Q: tokenStringsQ)

declare
  args: tokenStrings;
  tmp: charString;

begin
  receive args from Q;
  new args.strings;
  for token in args.tokens[] inspect
    select case of token
    where ('word')
      reveal token.word;
      insert copy of token.word into args.strings;
    where ('delimiter')
      reveal token.delimiter;
      new tmp;
      insert copy of token.delimiter into tmp;
      insert tmp into args.strings;
    where ('quotedString')
      reveal token.quoted;
      insert copy of token.quoted.string into args.strings;
    where ('bracketedString')
      reveal token.bracketed;
      insert copy of token.bracketed.string into args.strings;
    otherwise
      exit cantHappen;
    end select;
  end for;
  
  return args;
  
on exit (cantHappen)
  print charString#"CantHappen happened in tokenStrings";

end process
