-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: personalrm.p
-- Author: Andy Lowry
-- SCCS Info: @(#)personalrm.p	1.2 3/13/90

-- This process serves as a "personal" resource manager, handling
-- calls directly via that rManager interface, without user names
-- supplied.  This is done by creating a resource manager a la
-- sysRManager interface, and a userRM filter process initialized with
-- the user name supplied by the caller.

personalRM: using (personalRM, sysRManager, userRM)
linking (rManager, userRM)

process (Q: personalRMQ)
  
declare
  args: personalRM;
  sysRM: sysRManager;
begin

  receive args from Q;
  sysRM <- rManagerInitFn#(create of process rManager)();
  args.rm <- userRMFn#(create of process userRM)(args.userName, sysRM);
  return args;

end process

