-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: uptolow.d
-- Author: Daniel M. Yellin
-- SCCS info: "@(#)uptolow.p	1.2 3/13/90"

-- this file receives a string and modifies it so that all uppercase letters
-- are lower case;
uptolow: using(uptolow)
process(q: uptolowQ)

declare
args: uptolowIntf;
c: char;
charVal: integer;
newCharVal: integer;
num: integer;
pos: integer;
 
begin block begin
  receive args from q;
  num <- size of args.string;
  if num < 1 then exit ex; end if;
  pos <- 0;
  while pos < num
  repeat
     remove c from args.string[pos];
     charVal <- convert of c;
     if (charVal >= convert of char#'A') and (charVal <= convert of char#'Z')
     then  -- must be converted to lowercase
       newCharVal <- (((convert of char#'a') + charVal) -(convert of char#'A'));
       insert (convert of newCharVal) into args.string at pos;
     else 
       insert c into args.string at pos;
     end if;
     pos <- pos + 1;
  end while;
  return args;

on exit(ex)
  return args;
end block;
end process
