-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: getString2.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)getstring2.p	1.2 3/13/90"
-- 4/14/89  modified getstring from /local/hermes/hermes/io so that
-- returned string is terminated by 'NL'

getString2: using (predefined, terminalIO, terminalInits, unix)
process (initQ: initGetStringQ)

declare
  init: initGetStringIntf;
  fgetc: fgetc_function;
  file: handle;
  charint: int;
  getStringQ: getStringQ;
  getString: getStringIntf;

begin
  receive init from initQ;
  fgetc := init.fgetc;
  file := init.file;
  new getStringQ;
  connect init.getString to getStringQ;
  return init;

  while boolean#'true' repeat
  block begin
    receive getString from getStringQ;

    call fgetc(file, charint);
    if boolean#(charint < int#0) then
      return getString exception endOfInput;
    else
      new getString.string;
      while boolean#(boolean#(charint >= int#0) and  
        boolean#(char#(CONVERT of charint) <> char#'NL')) repeat
        insert char#(convert of charint) into getString.string;
        call fgetc(file, charint);
      end while;
      insert 'NL' into getstring.string;
      return getString;
    end if;

  on (fgetc_call.semantic_error)
    print charstring#"getstring2: exception fgetc_call.semantic_error";
    new getstring.string;
    return getstring;
  end block;
  end while;

end process
