-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: getNonCommentLine.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)getnoncommentline.p	1.3 3/13/90"
-- getNonCommentLine(getstring:getStringFunc) returns the next 
-- non-comment line in the Hermes program. The returned line is
-- stripped of leading and trailing spaces and of any comments.  


-- NOTE: CURRENTLY this does not handle /* */ comments!!!!


getNonCommentLine: using(predefined,terminalio,getuses)
process(getQ: getlineQ)

declare
  getM: getlineIntf;
  line: charstring;
  line2: charstring;
  pos: integer;
  lastchar: integer;
  found: boolean;
  c: char;
begin
  block begin
    receive getM from getQ;
    line <- getM.getstring();   -- get first line
-- NOTE: line is terminated by 'NL' (newline)
    pos <- 0;  
    c := line[pos];

    found := 'false';  -- originally non-comment line is not found
    while (not found) repeat
      while  (c = ' ')     -- skip spaces
      repeat
        pos <- pos + 1;
        c := line[pos];
      end while;
      if (c <> 'NL')       
      then
        if (c <> '-')
        then found <- 'true';
        else
          if line[pos + 1] <> '-' 
          then found <- 'true';
          end if;
        end if;
      end if;
      if not found -- this was a blank line or a comment line so get next line
      then
        line <- getM.getstring();   -- is this a non-comment line?
        pos <- 0;  
        c :=  line[pos];
      end if;
    end while;  

-- c = line[pos] points to first char in non-comment line.
-- now need to strip off trailing comments.  
    found <- 'false';
    new line2;
    while (not found) and c <> 'NL'
    repeat
      if c = '-' and line[pos + 1] = '-'
      then found <- 'true';
      else 
         insert c into line2;
         pos <- pos + 1;
         c := line[pos];
      end if;
    end while;

-- line2 now needs to be stripped of trailing white space and a 'NL' needs to
-- be inserted at the end.  
    lastchar := size of line2 - 1;
    while line2[lastchar] = ' '
    repeat
      remove c from char in line2 where (position of char = lastchar);
      lastchar <- lastchar - 1;
    end while;
    insert 'NL' into line2;  -- insert a trailing 'NL' char

    getM.s <- line2;
    return getM;

  on (getStringIntf.endOfInput)
    return getM exception endOfInput;
  end block;
end process



