-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: make.d
-- Author: Daniel Yellin
-- SCCS Info: "@(#)make.d	1.2 3/13/90"

make: using (predefined)
definitions

-- Dependency Graph Structure

dependencyGraph: table of node { full } keys (name);

node: record (
  name: charstring,		-- name of this node (usually a filename)
  successors: charstringSet,	-- nodes that depend on this one
  action: ActionFunc,		-- action to make this node up-to-date 
				--  (usually a compilation function).
  mustMake: boolean,		-- must the action be invoked?
  status: status	        -- was GetDepdendencies and Make at the node 
                                -- tried? was it succesful? 
);

status: enumeration(
   'DependenciesFailure',       -- GetDependecies failed at node
   'DependenciesSuccess',       -- GetDepend. succeeded & never tried action
   'ActionFailure',             -- action failed at node 
   'ActionSuccess'              -- action succeeded at node 
);

charstringSet: table of charstring { init } keys (*);

-- note: we would have used a relational representation for the graph but
-- were dissuaded by the lack of indices (secondary keys), which would have 
-- made looking up all edges with a given source O(N).

-- Language Dependent Functions

GetDependenciesIntf: callmessage (
  nodename: charstring,		-- node whose dependencies we want to check
  uses: charstringSet,		-- names of nodes that it depends upon
  action: ActionFunc,		-- function to "make" this node.	
  mustMake: boolean		-- must this node be made?
) constant (nodename)
  exit { full }
  exception dependencyFailure { init(nodename) };

GetDependenciesQ: inport of GetDependenciesIntf { init(nodename) };
GetDependenciesFunc: outport of GetDependenciesQ;


ActionIntf: callmessage (
  made: boolean			-- out: were we able to make it?
) 
  exit { full };

ActionQ: inport of ActionIntf {};
ActionFunc: outport of ActionQ;

-- Language Independent: The Make Engine

ActionControl: enumeration ( 
  'None',			-- just build the graph, take no action.
  'Inconsistent',		-- do action to all out of date modules.
  'All'				-- do action to all modules (in order).
);

ErrorControl: enumeration ( 
  'Stop',			-- halt immediately on errors.
  'Ignore',			-- ignore all errors.
  'Continue Other Paths'	-- on errors stop processing successors
				--  of this node but process independent paths.
);

MakeIntf: callmessage (
  root: charstringSet,          -- root objects to be made
  actionControl: actionControl,	-- controls how much action to take.
  errorControl: errorControl,	-- what to do when there is an error.
  getDependencies: getDependenciesFunc,  -- function to get dependencies 
  graph: dependencyGraph	-- resulting dependency graph
) constant (actionControl, errorControl, getDependencies)
  exit { full }
  exception Circular { full }	-- stopped due to circular graph
  exception NotMade  { full };	-- an error occured somewhere in make

MakeQ: inport of MakeIntf { init(root), init(actionControl), init(errorControl),
	init(GetDependencies) };
MakeFunc: outport of MakeQ;

end definitions
