-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)type_inference.d	1.5 3/13/90

type_inference: using (predefined)
definitions

-- a type inference rule maps the type of one of the operands into the type
-- of another operand.  each table entry contains (1) the 'name' of the 
-- function which performs the mapping, (2) the position in the operand list
-- of the operand whose type will be supplied to the function, and (3) the
-- position of the operand whose type it will yield.
--
-- the signature of the infer_type function is:
--    infer_type: (typename, definitions_modules) -> typename

  type_inference_rules: ordered table of type_inference_entry { full } ;

  type_inference_entry: record (
    function: type_inference_function,
    argument: integer,  
    result: integer
  );

  type_inference_function: enumeration ('sameas', 'casetypeof', 'matchinginportof',
    'messagetypeof', 'elementtypeof');
  
-- a type assignment rule returns the type of one of the operands.  each table 
-- entry contains (1) the 'name' of the function which performs the mapping, 
-- and (2) the position of the operand whose type it will yield.
--
-- the signature of the assign_type function is:
--    assign_type: definitions_modules -> typename

  type_assignment_rules: table of type_assignment_rule {full};
-- the aabove table is NOT ordered, since no rule needs to reinvoked. (Unlike type 
-- inference and class rules that need to be reinvoked if the type of their 
-- argument is unknown at the first invocation.)

  
  type_assignment_rule: record (
    function: type_assignment_function,
    result: integer
  );
  
  type_assignment_function: enumeration ('predefinedprogram',
    'predefineddefinitionsmodule', 'predefineddefinitionsmodules', 
    'predefinedboolean', 'predefinedtypeofvalue', 'predefinedtypestateofvalue',
    'predefinedinteger', 'predefinedtypename', 'predefinedattribute_name'
    );


-- a type class rule tells whether a particular type falls into a
-- specific type class or not.  the table contains (1) the 'name' of
-- the function, and (2) the position in the operand list of the operand
-- which is to be checked.
--
-- the signature of the check_type_class function is:
--    check_type_class: (typename, definitions_modules) -> boolean

  type_class_rules: ordered table of type_class_entry { full } ;

  type_class_entry: record (
    function: type_class_function,
    argument: integer
 );

  type_class_function: enumeration ('boolean', 'numeric', 'variant',
    'string', 'inport', 'outport', 'copyable', 'orderedscalar', 
    'table', 'integer', 'enumerationorboolean', 'nominal', 
    'enumeration', 'newable', 'polymorph', 'callmessage', 'orderedtable',
    'callmessageOutport', 'variantcomponent'
    );

end definitions
