/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)l_gentab.l	1.5 3/19/90 */

%{

#include "gentab.h"
#include "tokens.h"
  extern char *symbol_string;
  extern char *safe_malloc();

%}

IS   		"IS"
IN              "IN"
SPECIAL         "SPECIAL"
VARIABLE        "VARIABLE"
letter		[a-zA-Z_]
digit		[0-9]
mark            "?"
symbol		{letter}({letter}|{digit}|{mark})*
whitespace      [ \t]+
newline		\n
comment		"--".*$      /* 2 leading dashes indicates a comment line */

%%
{IS}		return(T_IS);
{IN}		return(T_IN);
{SPECIAL}       return(T_SPECIAL);
{VARIABLE}      return(T_VARIABLE);
"*"		return('*');
"("		return('(');
")"		return(')');
","		return(',');
";"		return(';');
"returnexception" 	{ 
                  symbol_string = "return exception";
		  return(T_SYMBOL); }
"programliteral"  	{ 
                  symbol_string = "program literal";
		  return(T_SYMBOL); }
"inspecttable"  	{ 
                  symbol_string = "inspect table";
		  return(T_SYMBOL); }
"inspectpolymorph"  	{ 
                  symbol_string = "inspect polymorph";
		  return(T_SYMBOL); }
"forenumerate"  	{ 
                  symbol_string = "for enumerate";
		  return(T_SYMBOL); }
"expressionblock"  	{ 
                  symbol_string = "expression block";
		  return(T_SYMBOL); }
{symbol}	{ symbol_string = (char *) safe_malloc(yyleng+1);
                  strcpy(symbol_string, yytext);
                  return(T_SYMBOL); }
{comment}      ;
[ \t\n] ;
