-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: shorten.p
-- Author: Rob Strom
-- SCCS Info: @(#)shorten.p	1.3 3/13/90

-- Given a formal typestate, eliminate all attributes implied by init(cm)
-- Algorithm:
-- 1. For each attribute, if it's of the form init(cm),
--    1.1 look up the minimum TS
--    1.2. For each attribute except INIT(*) in the minimum TS,
--         form a new attribute with CM prepended to each object name,
--         and insert this attribute (if not already inserted), into
--         the Removes list
-- 2. Remove all attributes from the formal typestate which appear on the
--    Removes list 

Shorten : USING( FixFull) PROCESS ( ShortenInit : FixFullInport)
DECLARE
    FP: FixFullCall ;
    Type: TypeName; -- of component being examined
    Removes: Formal_Typestate; -- set of attributes to remove
    Removed: Formal_Typestate; -- set of attributes removed
  BEGIN
      
    -- 1.
    RECEIVE FP FROM ShortenInit ;
    NEW Removes;
    FOR FormalAttribute in FP.Formal WHERE('true')
      INSPECT
        IF CASE OF FormalAttribute.Attribute_Name = 'initialized'
          THEN
            INSPECT FormalObject IN FormalAttribute.Parameters WHERE('true')
              BEGIN
                Type := FP.RootType;
                FOR Component IN FormalObject WHERE('true')
                  INSPECT
		    INSPECT Module IN FP.Definitions WHERE(boolean # (Module.Id = Type.ModuleId))
		      BEGIN
			INSPECT Definition IN Module.Type_Definitions WHERE(boolean # (Definition.Id = Type.TypeId))
			  BEGIN
			    INSPECT ComponentDeclaration IN Definition.Component_Declarations WHERE(ComponentDeclaration.Id = Component)
			      BEGIN
			        Type := ComponentDeclaration.Type;
			      END INSPECT;
			  END INSPECT;
	              END INSPECT;
		  END FOR;
		INSPECT Module IN FP.Definitions WHERE(boolean # (Module.Id = Type.ModuleId))
		  BEGIN
		    INSPECT Definition IN Module.Type_Definitions WHERE(boolean # (Definition.Id = Type.TypeId))
		      BEGIN
			IF CASE OF Definition.Specification = 'callmessagetype'
			  THEN
			    -- 1.1.
			    REVEAL Definition.Specification.Callmessage_info;
			    INSPECT MinimumException IN Definition.Specification.Callmessage_info.Exception_Specifications[Definition.Specification.Callmessage_info.Minimum]
			      BEGIN
			        -- 1.2.
			        FOR MinimumAttribute IN MinimumException.Post_Typestate WHERE('true')
			          INSPECT
			            IF CASE OF MinimumAttribute.Attribute_Name = 'initialized' AND SIZE OF MinimumAttribute.Parameters[0] = 0
			              THEN
			              ELSE
			                BLOCK
			                  BEGIN
					    INSERT EVALUATE RedundantAttribute: Formal_Attribute FROM
					      NEW RedundantAttribute;
					      RedundantAttribute.Attribute_Name := MinimumAttribute.Attribute_Name;
					      NEW RedundantAttribute.Parameters;
					      FOR Parameter IN MinimumAttribute.Parameters WHERE('true')
						INSPECT
						  INSERT FormalObject | Parameter INTO RedundantAttribute.Parameters;
						END FOR;
					      END INTO Removes;
					  ON (DuplicateKey)
					  END BLOCK;
			              END IF;
			          END FOR;
			      END INSPECT;
			  END IF;
		      END INSPECT;
		  END INSPECT;               
              END INSPECT;
          END IF;
      END FOR;
    -- 2.
    EXTRACT Removed FROM A IN FP.Formal WHERE(EXISTS OF A1 IN Removes WHERE(A1 = A));
    DISCARD Removed;
    RETURN FP;
  END PROCESS
