-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: libwriteobj.p
-- Author: David F. Bacon
-- SCCS Info: @(#)libwriteobj.p	1.4 3/13/90

libwriteobj: using (predefined, libinit, objectio, cwd)
process (initQ: initLibWriteObjectQ)

declare
  initArgs: initLibWriteObject;
  write: writeObject_Func;
  directory: charstring;
  q: writeObject_Q;
  args: writeObject_Intf;
  filename: charstring;
  getCwd: getCwdFn;
  
begin
  receive initArgs from initQ;
  write := initArgs.write;
  getCwd := initArgs.getCwd;
  new q;
  connect initArgs.libWrite to q;
  return initArgs;

  while boolean#'true' repeat
    block begin
      receive args from q;
      filename <- charstring#(charstring#(charstring#(
	getCwd()) | charstring#"/") | args.filename);
      call write(filename, args.object);
      return args;

    on (writeObject_Intf.object_Not_Writeable)
      return args exception object_Not_Writeable;
    on (writeObject_Intf.file_Not_Writeable)
      return args exception file_Not_Writeable;
    end block;
  end while;
end process


