/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: module.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)module.ch	1.20 3/13/90";
#endif

#include "cherm.h"
#include "resolve.h"
#include "storage.h"

#include "predefined.cd"
#include "filedef.cd"
#include "parse.cd"
#include "errors.cd"


extern flag integrated;		/* are we integrated with backend or not? */

hobject(SCDefmod,record);	/* the definitions module being built. */

static char *module_name;

static flag isdefmod;		/* set if we are compiling a definitions mod */


/* generic initialization for both definitions and process modules */
void
p_mod_init(name)
char *name;			/* constant string: name of module */
{
    void init_printmap();
    void check_module_name();
    void p_mod_import();


    init_printmap();		/* initialize the print mappings */
    init_links();

    module_name = name;		/* save ptr to the module name. */
    check_module_name();	/* avoid confusion from redundant */
				/* names introduced by filesystem */

    Absprog = new_object();
    new_program(Absprog);	/* create an empty absprog */
    avl_new_table(Absprog@program__definitions_modules, firstelem_key);
				/* key = id */
    avl_new_table(Absprog@program__programs, firstelem_key); /* key = id */

    if (strcmp(name, "predefined") isnt 0)
      p_mod_import(copystring("predefined"));
}


char *
get_module_name()
{
    return(module_name);
}


/* issue a warning if parsed module name disagrees with source file name */

static void
check_module_name()
{
    char *get_module_name(), *get_srcfile_name(),*rindex();
    char *mname,*fname,*fsuffix;

    mname = get_module_name();
    fname = get_srcfile_name();
    
    if (fname is nil)		/* no srcfile name for comparison */
      return;			/* so don't complain */

    fsuffix = rindex(fname,'/'); /* only look at final path component */
    if (fsuffix isnt nil)
      fname = fsuffix+1;
    fsuffix = rindex(fname,'.'); /* exclude filename suffix */
    if (fsuffix is nil)
      fsuffix = fname+strlen(fname);

    if (strncmp(mname,fname,fsuffix-fname) != 0)
	fe_error(Warning, errorcode__general_error,
		 "Module name %s declared in sourcefile %s",
		 mname,fname);
}

void
p_mod_end()
{
}


void
p_init_def_module(pragm)
char *pragm;
{
    void create_definitions_printmap();
    void init_unqualnames();
    void set_isdefmod();

    hobject(SDef, record);


    if (integrated) {
	if (not isdefmod)
	  fe_error(Stop_Now, errorcode__general_error,
		   "syntax error - process looks like a definitions module");
    }
    else
      set_isdefmod(TRUE);	/* indicate that we are compiling a defmod */

    init_unqualnames();		/* initialize unqualified name table */

    new_record(SDef, definitions_module);

    unique(SDef@Id);
    avl_new_table(SDef@definitions_module__type_definitions, firstelem_key);
				/* key = id */
    avl_new_table(SDef@definitions_module__attr_definitions, firstelem_key);
				/* key = id */

    create_definitions_printmap(module_name, SDef@Id);
				/* make the printmap for this module. */

    Typedefinitions = SDef@definitions_module__type_definitions;
    Attrdefinitions = SDef@definitions_module__attr_definitions;
				/* save pointers to these for fast access */
				/*  when adding new definitions. */

    cheapcopy(SCDefmod, SDef);	/* save a cheap copy for later. */
    insert(Absprog@program__definitions_modules, SDef);
				/* insert the new def module into the table. */
}


void
init_proc_module()
{
    void set_isdefmod();

    if (integrated) {
	if (isdefmod)
	  fe_error(Stop_Now, errorcode__general_error,
		   "syntax error - definition looks like a process");
    }
    else
      set_isdefmod(FALSE);
}


void
set_isdefmod(val)
flag val;
{
    isdefmod = val;
}

flag
is_definitions_module()
{
    return(isdefmod);
}

objectp				/* out constant moduleid */
get_defmodid()
{
    if (isdefmod)
      return(SCDefmod@Id);	/* return a pointer to moduleid */
    else
      return(nil);
}


static objectp
read_filed_definition(Name)
objectp Name;			/* constant chs_table */
{
    objectp io_read_definition();

    return(io_read_definition(Name));
}




void
p_mod_import(modname)
char *modname;			/* in string */
{
    void do_indirect();
    status module_in_printmap();

    lobject(SName);
    objectp Filedef;		/* filed_definition */


    chs_lit(SName,modname);

    if (strcmp(modname, "predefined") isnt 0 or
	(strcmp(modname, "predefined") is 0 and not module_in_printmap(SName)))
      {

	Filedef = read_filed_definition(SName);
	
	if (Filedef) {
	    if (add_modulemap(SName,
			      Filedef@filed_definition__definitions_module@Id))
	      do_indirect(Filedef, modname);
	    else
	      discard(Filedef);	/* insert failed. trash it. */
	    
	}
    }

    discard(SName);
}


static void
do_indirect(Filedef, modname)
objectp Filedef;		/* in filed_definition */
char *modname;			/* const string: name of importer */
{
    void import_uar();
    void add_def_printmap();
    void add_proc_printmaps();

    hobject(SPrec, record);
    objectp Dimports;


    if (insert(Absprog@program__definitions_modules,
		   Filedef@filed_definition__definitions_module)
				/* insert definitions_module into absprog */
	is DuplicateKey) {
	discard(Filedef);
	return;
    }

    add_def_printmap(Filedef@filed_definition__defmap); /* add printmappings */
    add_proc_printmaps(Filedef@filed_definition__procmaps);

    /* now import indirectly each module that the one we just read imports */
    /* directly.  if there are any duplicates, just ignore them, since two */
    /* modules might indirectly import the same module */

    Dimports = Filedef@filed_definition__direct_imports;
    initget(SPrec, Dimports, nil);

    while (get_or_err(SPrec, Dimports) is Normal)
      import_uar(SPrec, modname);

    endget(SPrec, Dimports);

    discard(Filedef);		/* throw away any remaining portions */
}


static void
import_uar(Printrec, modname)
objectp Printrec;		/* module_printrec */
char *modname;			/* const string: name of importer */
{
    hobject(SDefmod,record);	/* definitions_module */
    hobject(SEq,boolean);	/* boolean */
    objectp Filedef;		/* filed_definition */


    if (h_lookup(SDefmod, Absprog@program__definitions_modules, 
		 Printrec@module_printrec__id, 0) is NotFound) {
				/* if not already imported, read it in... */
	Filedef = read_filed_definition(Printrec@module_printrec__name);
				/* ...and indirectly import IT. */

	if (Filedef) {
	    equal(SEq, Filedef@filed_definition__defmap@Id,
		  Printrec@module_printrec__id);
	    if (not SEq_val) {
		fe_error(LASTPHASE, errorcode__general_error,
			 "Module '%s' was compiled with a different version of module '%s' than the one which was loaded",
			 modname, stringval(Printrec@module_printrec__name));

		discard(Filedef);
	    }

	    do_indirect(Filedef, stringval(Printrec@module_printrec__name));
	}
    }
}



void
p_end_def_module()
{
    void io_write_definition();
    void bp_end();
    void end_unqualnames();
    objectp get_def_printmap();	/* returns definitions_printmap */
    objectp get_prog_printmap(); /* returns executable_printmap */
    objectp get_mod_printmap();	/* returns module_printmap */


    bp_end();
    end_unqualnames();		/* clean up unqualified name table */

    io_write_definition(module_name, 
			SCDefmod@Id, Absprog@program__definitions_modules,
			get_def_printmap(), get_prog_printmap(),
			get_mod_printmap());
}


void
p_end_proc_module()
{
    void io_write_proc();
    objectp get_prog_printmap(); /* returns executable_printmap */
    objectp get_mod_printmap();	/* returns module_printmap */
    objectp p_end_process();	/* returns constant processid */
    objectp get_posmaps();
    objectp get_links();


    copy(Absprog@program__main_program, p_end_process());

    io_write_proc(module_name, Absprog, 
		  get_def_printmap(), get_prog_printmap(), get_posmaps(),
		  get_mod_printmap(), get_links());
}


void
p_unsupported()
{
    fe_error(Stop_Now, errorcode__general_error,
	     "Use of unsupported language feature");
}
