-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
disassembler: using (predefined,interpform,disassembler,listuff,disinternal)
  process (Q: disassemblerQ)
  declare
    args: disassembler!disassembler;
    qualifier: interpform!qualifier;
    dis: dis;
    line: charstring;
    code: charstring;
  begin
    receive args from Q;
    -- load the pieces of the disassembler
    new dis;
    dis.pms := args.printmaps;
    new dis.label;
    dis.label.prog_name <- charstring#"(Not a prog_name)";
    dis.label.line_base <- charstring#"(Not a line_base)";
    dis.label.label_base <- charstring#"(Not a label_base)";
    dis.label.exit_base <- charstring#"(Not a exit_base)";
    dis.label.indentation <- integer#0;
    dis.label.max_blanks <- integer#0;
    new dis.label.dests;
    new dis.label.exits;
    dis.operation <- disoperationFn#(
	procedure of predefined!program#(
	    args.stdenv.pathLoad
	       (predefined!charstring#"disoperation")));
    dis.opcode <- disopcodeFn#(
	procedure of predefined!program#(
	    args.stdenv.pathLoad
	       (predefined!charstring#"disopcode")));
    dis.operand <- disoperandFn#(
	procedure of predefined!program#(
	    args.stdenv.pathLoad
	       (predefined!charstring#"disoperand")));
    dis.qualifier <- disqualifierFn#(
	procedure of predefined!program#(
	    args.stdenv.pathLoad
	       (predefined!charstring#"disqualifier")));
    dis.integer <- disintegerFn#(
	procedure of predefined!program#(
	    args.stdenv.pathLoad
	       (predefined!charstring#"disinteger")));
    dis.blanks <- disblanksFn#(
	procedure of predefined!program#(
	    args.stdenv.pathLoad
	       (predefined!charstring#"disblanks")));
    dis.unstuff <- LIUnstuffFn#(
	procedure of predefined!program#(
	    args.stdenv.pathLoad
	       (predefined!charstring#"liunstuff")));
    -- Create inport list
    line <- charstring#"using ( ";
    for module in dis.pms.defs[]
      inspect
	merge charstring#(copy of module.name) into line;
	insert char#' ' into line;
      end for;
    insert char#')' into line;
    insert char#'NL' into line;
    -- print line;
    -- pretend we have been given a "code" qualifier
    unite qualifier.code from prog#(copy of args.LIprog);
    -- Dissassemble the prog
    -- print charstring#"Disassembling code:";
    code <- dis.qualifier(dis,qualifier,opcode#'noop');
    -- print charstring#"code:";
    -- print code;
    merge code into line at integer#(size of line);
    -- print charstring#"prog:";
    -- print line;
    args.code <- line;
    return args;
  on (disqualifier.Unsupported)
    return args exception Unsupported;
  end process
   

