-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: cgclause.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)cgclause.pp	1.10 3/13/90

-- This function performs initial code generation for a single clause.
-- Code is generated into the current basic block as given by
-- cgData.Proc.BBData.curBB, though by the time this clause is
-- finished, there may be several new basic blocks, and the current BB
-- may have changed.

#include "typemark.h"
#include "codegen.h"

cgClause: using (cgInternal, positions)

process (Q: cgClauseQ)

declare
  args: cgClause;
  pos: Aposition;
begin
  receive args from Q;

  -- Translate any pre-clause coercions that may be needed
  block begin
    inspect hc in args.cgData.Proc.coercions.handlerCoercions[args.clauseid]
    begin
      for stmt in hc.coercions[] inspect
	call FNS.cgStmt(stmt,args.cgData);
      end for;
    end inspect;
  on (NotFound)
    -- No coercions prior to this clause
  end block;
  
  -- Build up a partial position indicator to use in looking up
  -- coercions
  new pos;
  pos.clause := args.clauseid;
  
  -- Locate the clause we're supposed to translate
  inspect proc in ABSPROG.programs[args.cgData.Proc.id] begin
    inspect clause in proc.executable_part.clauses[args.clauseid] begin
      -- Now translate each statement in the clause in turn
      for stmt in clause.statements[] inspect
	pos.statement := stmt.id;
	-- Translate pre-coercion statements
	block begin
	  inspect sc in args.cgData.Proc.coercions.precoercions[pos] begin
	    for prestmt in sc.coercions[] inspect
	      call FNS.cgStmt(prestmt,args.cgData);
	    end for;
	  end inspect;
	on (NotFound)
	  -- no coercions prior to this stmt
	end block;

	-- Now the statement itself
        call FNS.cgStmt(stmt,args.cgData);
      
      	-- And finally post-coercions
	block begin
	  inspect sc in args.cgData.Proc.coercions.postcoercions[pos] begin
	    for poststmt in sc.coercions[] inspect
	      call FNS.cgStmt(poststmt,args.cgData);
	    end for;
	  end inspect;
	on (NotFound)
	  -- no coercions prior to this stmt
	end block;

      end for;
    end inspect;
  end inspect;

  return args;			-- all done

end process
