/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1994  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.7 of 15-Sep-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * memory.c ---		The Optional Memory Allocation Word Set
 * (duz 08Jul93)
 */

#include <stdlib.h>
#include <errno.h>

#include "config.h"
#include "forth.h"


Code (allocate)
{
  if ((*sp = (Cell)malloc ((size_t)*sp)) != 0)
    *--sp = 0;
  else
    *--sp = errno;
}

Code (free)
{
  errno = 0;
  free (*(void **)sp);
  *sp = errno;
}

Code (resize)
{
  void *p = realloc ((void *)sp [1], (size_t)sp [0]);
  if (p == NULL)
    sp [0] = errno;
  else
    sp [1] = (Cell)p, sp [0] = 0;
}


LISTWORDS (memory) =
{
  CO ("ALLOCATE",	allocate),
  CO ("FREE",		free),
  CO ("RESIZE",		resize)
};
COUNTWORDS (memory, "Memory allocation");
