;; arglist scanner
;; lets hope that this is compiled!
(defmodule scan-args
  (standard0)
  ()
  (defun scan-args (arg lst default)
    (cond ((null lst) default)
	  ((eq (car lst) arg) (cadr lst))
	  (t (scan-args arg
			(cddr lst)
			default))))

  (defun map-initargs (fn lst)
    (cond ((null lst)
	   nil)
	  (t (cons (fn (car lst) (cadr lst))
		   (map-initargs fn (cddr lst))))))

  (defun fold-initargs (fn lst start)
    (if (null lst)
	nil
      (fold-initargs fn (cddr lst) 
		     (fn (car lst) (cadr lst) start))))

  (export scan-args map-initargs fold-initargs)
)
