.nr PS 10
.nr VS 12
.nr PD .7v
.nr LL 6.5i
.TL
 ** DRAFT **
 A Runtime Type Checking and Query Mechanism for C++
 ** DRAFT **
.AU
Mary Fontana
LaMott Oren
.AI
Texas Instruments Incorporated
Computer Science Center
Dallas, TX
.AU
Martin Neath
.AI
Texas Instruments Incorporated
Information Technology Group
Austin, TX
.ND 
.AB
The Texas Instruments C++ Object-Oriented Library (COOL) is a collection of
classes, templates and macros for use by C++ programmers writing complex
applications.  Symbolic computing in COOL is one component of this library that
substantially improves the development capabilities available to the programmer
by providing symbol and package manipulation and runtime type checking and type
query.  This paper will focus on the implementation of runtime type checking
and query.
.AE
.NH 1
Introduction
.LP
The Texas Instruments C++ Object-Oriented Library (COOL) is a collection of
classes, templates and macros for use by C++ programmers writing complex
applications.  An important feature of this library is the symbolic
computing capability which provides symbol and package manipulation and
runtime type checking and query.
This paper will describe the runtime type checking capability.
For details on symbols and packages in COOL, see the paper,
.I
Symbols and Packages in C++
.R
[4].
For an overview of the COOL class library, see the paper,
.I
COOL - A C++ Object-Oriented Library 
.R
[1].
For complete details, see the reference document,
.I
COOL User's Guide 
.R
[5].

The ability to query an object at runtime to determine its type is commonly
used in many symbolic computing and complex knowledge-intensive operations
management applications.  Such capability is found in highly dynamic languages
such as SmallTalk [7] and Common LISP [8], but the C++ language does not 
support this.  COOL facilitates a runtime type checking and query capability for
C++ classes with the \fBGeneric\fR class, the \fBSymbol\fR
class, the \fBSYM\fR macro and the \fBclass\fR macro.  The \fBGeneric\fR class
provides the \fBtype_of\fR and \fBis_type_of\fR member functions for runtime
type checking and query. 
\fBtype_of\fR returns the class type of the object and
\fBis_type_of\fR determines whether the class type of the object
inherits from a specified class type. 
The \fBSymbol\fR class is used to represent the type information of a class
object.
The \fBSYM\fR macro stores symbol names in the
"sym_package.p" file 
which is used to automatically create symbol objects at program startup.
Finally, the COOL \fBclass\fR macro generates the class hierarchy
structure and the \fBtype_list\fR virtual member function for classes
singly or multiply derived at some point from the \fBGeneric\fR class.
.NH 1
Symbols
.LP
COOL supports symbolic constants and runtime symbolic objects.
The \fBSymbol\fR class implements the notion of a symbol object that has a
name, value and property list (see Figure 1). 
\fBSymbol\fR objects can be created and interned into
a package, which is merely a mechanism for establishing separate name spaces
for groups of symbols [4].  \fBSymbol\fR objects are also utilized by the
\fBGeneric\fR runtime type checking and query member functions as a way of
representing the type information of a class object.  A \fBSymbol\fR object is
automatically created at program starup for each class derived from 
\fBGeneric\fR
with name set to the class name and value and property list set to \fBNULL\fR.

The \fBSYM\fR and \fBclass\fR macros are implemented with the COOL macro
facility [2] which gives special directives to the COOL preprocessor.
The \fBclass\fR macro (discussed below) uses \fBSYM\fR 
to create Symbol objects for \fBGeneric\fR-derived classes.
\fBSYM(\fIname\fB)\fR is replaced in the source code with the address of the 
Symbol object for \fIname\fR.  At the same time, \fI"name"\fR is added
to the file "sym_package.p".
The total number of symbols and the names of all the symbols in an
application are saved in "sym_package.p".
The file "symbols.C" initializes a global array of symbols objects
with the names stored in  "sym_package.p" and is
compiled and linked with the rest of the application files.

The application uses the COOL C++ Control program (CCC), instead of the normal
CC procedure, to control the compilation process. This program provides all of
the capabilities of the original CC program with additional support for the
COOL preprocessor.  Figure 2 shows the flow of the COOL compilation
process using CCC and "symbols.C".

.B Example
.DS I
Foo.C                                          Foo.i
  class Generic;                                 class Generic;
  Generic* obj;                                  Generic* obj;
  if (obj->is_type_of(SYM(foo)) {            if (obj->is_type_of(&SYM_symbols[0])) {
  ...                                                 ...
  }                                                   }

Bar.C                                          Bar.i
  class Generic;                                 class Generic;
  Generic* obj;                                  Generic* obj;
  if (obj->is_type_of(SYM(bar)               if (obj->is_type_of(&SYM_symbols[1])
      || obj->is_type_of(SYM(baz))               || obj->is_type_of(&SYM_symbols[2]))
  ...                                                 ...
  }                                                   }
  
.DE
.DS I
// from sym_package.p

  #define SYM_count  2
  MACRO SYM_DEFINITIONS(define_name) {
  define_name(0,"foo");
  define_name(1,"bar");
  define_name(2,"baz");
}

#define MAKE_SYM(index, symbol) \
  SYM_symbols[index].name = symbol;
.DE
.DS I
// from Symbols.C

 #include "sym_package.p"
 Symbol SYM_symbols[2];   // SYM_count
 void SYM_package_initializer() {
   ...
   // SYM_DEFINITIONS(MAKE_SYM);
   SYM_symbols[0].name = "foo";
   SYM_symbols[1].name = "bar";
   SYM_symbols[2].name = "baz";
 }

static Package SYM_package_s(SYM_package_initializer);
.DE
.NH 1
Generic class
.LP
The \fBGeneric\fR class is inherited by all COOL classes.  
For a complete definition of this class see Figure 3.
It provides runtime
type checking capabilities for any class that uses it as a base class.  
This information is accessed with the following member functions:

\fBSymbol* Generic::type_of ();\fR
.RS
Returns the symbol type associated with the object.  
.RE

\fBBoolean Generic::is_type_of (Symbol* type);\fR
.RS
Returns \fBTRUE\fR if the object is the specified type or inherits from that
type somewhere in its class hierarchy, otherwise returns \fBFALSE\fR.
.RE

\fBint Generic::select_type_of (Symbol** type_vector);\fR
.RS
If the object's symbol type is found in the specified array of pointers to
symbols, returns the integer index of the matching symbol type, otherwise
returns -1.  The \fBTYPE_CASE\fR macro (discussed later)
uses this member function with the \fBswitch\fR statement to select an
appropriate execution path based upon the symbol type of the object.
.RE

\fBvirtual Symbol** Generic::type_list();\fR
.RS
Returns a \fBNULL\fR-terminated array whose first element is a
pointer to the symbol for the class being defined.  The rest of the array
elements are pointers to the \fBtype_list\fRs of the base classes.
.RE

The \fBtype_list\fR member function represents the class hierarchy of the
\fBGeneric\fR-derived class. 
Note that the \fBtype_list\fR member function is virtual. 
Each class derived from \fBGeneric\fR has a \fBtype_list\fR member function
which is generated automatically by the \fBclass\fR macro. 
The \fBtype_of\fR, \fBis_type_of\fR and \fBselect_type_of\fR member functions
use the virtual \fBtype_list\fR member function to access the class hierarchy of
the class object.

.B Example

The following example shows runtime type checking operations on the variable
\fBn\fR which is of type \fBLong\fR.   \fBLong\fR is derived from \fBGeneric\fR.
In this example, \fBSYM(Long)\fR is a pointer to a \fBSymbol\fR object, 
\fB&SYM_entry[13]\fR.
.DS I
extern Generic* n = Long(123);
static Symbol* sym_list[4] = { SYM(long), SYM(Long), SYM(Integer), NULL };

n->type_of ();                          // returns  &SYM_entry[13]
n->is_type_of (SYM(Long);         // returns  TRUE
n->is_type_of (SYM(long));         // returns  FALSE
n->select_type_of (sym_list);        // returns  1
.DE
.NH 1
Class macro
.LP
The keyword \fBclass\fR is a COOL macro 
which  takes a C++ class description and generates code to
support the runtime type checking and query mechanism.
The \fBclass\fR macro adds the following lines into the class definition.
.DS I
protected:
    virtual Symbol** type_list ();
.DE

The definition of the \fBtype_list\fR member function
and the array of symbol pointers representing the class
hierarchy of the class are added after the class definition.  

.B Example

The following example shows how the class \fBLong\fR which is derived from
class \fBGeneric\fR is expanded by the COOL \fBclass\fR
macro.  The additional code generated is highlighted in bold.  Note that
\fBLong_types\fR is a NULL-terminated array of symbol pointers whose first
element is a pointer to the \fBLong\fR symbol and second element is a pointer
to \fBGeneric_types\fR which contains the \fBGeneric\fR symbol pointer.

.DS I
class Long : public Generic {
  private:
    long num;
  public:
    Long (long value) { num = value; };			// Make a long
    long operator long () { return this->num; };		// Get the value out
};
.DE
expands to:
.DS I
class Long : Generic {
  private:
    long num;
.B
  protected:
    virtual Symbol** type_list ();
.R
  public:
    Long (long value) { num = value; };			// Make a long
    long operator long () { return this->num; };		// Get the value out
};

.B
extern Symbol* Generic_types[];				// initialized to {SYM (Generic), NULL }

Symbol* Long_types[] = { SYM (Long), (Symbol*) Generic_types, NULL };

Symbol** Long::type_list () { return Long_types; }
.R
.DE

.NH 2
Classmac macro
.LP
The actual code which is expanded in a class definition and after
a class definition is controlled by the \fBclassmac\fR macro.
Each \fBclassmac\fR macro
defines how the \fBclass\fR macro should expand the class definition.
The \fBclass\fR
macro does not actually generate the code itself. This is defined in
user-modifiable header files that specify \fBclassmac\fR macros.
Thus no changes to the COOL preprocessor are required.

In the following example,
the \fBtype_list\fR member function for the Generic-derived class
is generated by defining two \fBclassmac\fR macros.  The \fBDECLARE_GENERIC\fR
macro expands the \fBtype_list\fR member function declaration inside the class
definition and the \fBIMPLEMENT_GENERIC\fR macro expands after the class the
definition for \fBtype_list\fR.  The \fBGENERATE\fR macro 
is used to generate block code for multiple base classes of a 
class definition.

.B
Example
.R
.DS I
classmac (DECLARE_GENERIC, inside)
classmac (IMPLEMENT_GENERIC)

MACRO DECLARE_Generic(class, REST: bases) {
  WHEN_GENERIC_CLASS(class, bases) {
     protected:
       virtual Symbol** type_list() CONST;
  }
}

MACRO IMPLEMENT_Generic(class, REST: bases, BODY: slots) {
  WHEN_GENERIC_CLASS(class, bases) {
     GENERATE(base, bases)
       { extern Symbol* base##_types[]; }
     Symbol* class##_types[] = 
       { SYM(class), GENERATE(base, bases) { (Symbol*) base##_types, } NULL };
     Symbol** class##::type_list() CONST { return class##_types; }
  }
}

.DE
The \fBclassmac\fR macro provides two hooks as a point of customization by user
defined macros.  A combination of data members and member functions of a class
definition are passed as arguments to the macros that can be changed or
customized by the application programmer.  There may be more than one
\fBclassmac\fR macro hook specified by the programmer. COOL has several and
other user-defined macros are simply chained together in a calling sequence
ordered according to the order of definition.  For example, in COOL there is
the \fBmap_over_slots\fR virtual member function which calls a
specified function on all of the data members in the class.  (The describe
member function would use \fBmap_over_slots\fR to display the name, value, and
type of each data member).  The definition of \fBmap_over_slots\fR is 
automatically generated for each \fBGeneric\fR-derived class
by defining \fBclassmac\fR with the data member hook.
The \fBsend_if_handles\fR member function which supports
the run-time query of objects for member function availability is generated by
utilizing the member function hook in \fBclassmac\fR.
.NH 1
TYPE_CASE
.LP
The \fBTYPE_CASE\fR macro is analogous to the C++ \fBswitch\fR statment. 
It gathers all possible type cases and allows the user to symbolically dispatch
on the type of object represented by the \fBcase\fR statements.
It uses the \fBGeneric::select_type_of\fR
member function as shown in the following macro expansion of \fBTYPECASE\fR.

.B
Example
.R
.DS I
Generic* g;
TYPE_CASE (g) {
  case Vector:                // If the object is a vector
    ....                          // Do something for Vector
    break;
  case List:                    // If the object is a list
    ....                          // Do something for List
    break;
  default:                      // Else do the rest
    ....
}
.DE
 expands to:
.DS I
Generic* g;
static Symbol* switch_symbols_g[3] = {SYM(Vector), SYM(List), NULL};
switch (g->select_type_of(switch_symbols_g)) {
  case 0:                     // If the object is a vector
    ....                         // Do something for Vector
    break;
  case 1:                     // If the object is a list
    ....                         // Do something for List
    break;
  default:                    // Else do the rest
    ....
}
.DE   

.NH 1
Comparison with Dossiers
.LP
The COOL runtime type checking and query capability is very similar to the 
Dossier interface proposed in the paper by Interrante and Linton,
.I
Runtime Access to Type Information in C++
.R
[6].
Both the \fBDossier\fR class and the COOL \fBSymbol\fR class represent the type
information of a class object.  Both the \fBmkdossier\fR tool and the COOL
preprocessor (running the \fBclass\fR macro) generate a C++ source file
("__dossier.h" and "sym_package.p") to contain the type information.  
The Dossier
interface generates type information for all classes, but COOL generates
runtime type member functions only on classes derived singly or multiply at
some point from the \fBGeneric\fR class.  This is done automatically by the COOL
preprocessor and the code actually generated can be customization by the user.
This next table attempts to show more comparisons between the two runtime
type information mechamisms.

.DS I
   DOSSIER                                   COOL
------------                                     -----------
extern Dossier** classes()                   extern Symbol SYM_symbols[]
Boolean Dossier::isA(Dossier*)             Boolean Generic::is_type_of(Symbol*)
Dossier* class::GetClassId()                Symbol* Generic::type_of()
DossierItr Dossier::parents()                Symbol** class::type_list()
DossierItr Dossier::children()               none

Class Foo foo;                                 class Foo foo;   // :public Generic
class Bar bar;                                 class Bar bar;    // :public Generic
extern Dossier* FOO;                       SYM(Foo);      // &SYM_symbol[0]
extern Dossier* BAR;                       SYM(Bar);      // &SYM_symbol[1]

foo.GetClassId()  returns FOO            foo.type_of() returns SYM(Foo)
foo.GetClassId()->isA(BAR)               foo.is_type_of(SYM(Bar))
.DE

.NH 1 
Conclusions 
.LP 
Texas Instruments has been using the symbolic computing capability in COOL for
the last two year.  Applications have utilized COOL symbols, packages, and
runtime type checking and type query of \fBGeneric\fR-derived class objects.
Most COOL classes contain \fBGeneric\fR base class.  A significant benefit of
this common base class is the ability to declare heterogenous container classes
parameterized over the \fBGeneric*\fR type. 
In addition, the COOL exception handling facility [3] takes
advantage of the runtime type checking of exception objects.
An automated method for generating the symbols objects for type information is
accomplished with the COOL macro facility [2].

COOL is currently running on a Sun SPARCstation 1\*(tm running SunOS\*(tm 4.x,
.FS
SunOS and SPARCstation 1 are trademarks of Sun Microsystems, Inc.
.FE
a PS/2\*(tm
.FS
PS/2 is a trademark of International Business Machines Corporation.
.FE
model 70 running SCO XENIX\(rg
.FS
XENIX is a registered trademark of Microsoft Corporation.
.FE
2.3, a PS/2 model 70 running OS/2\*(tm
.FS
OS/2 is a trademark of International Business Machines Corporation.
.FE
1.2, and
a MIPS running RISC/os 4.0. The SPARC and MIPS ports utilize the AT&T C++
translator (cfront) version 2.x and the XENIX and OS/2 ports utilize the
Glockenspiel C++ translator with the Microsoft C compiler.
.NH 1
References
.IP [1]
Mary Fontana, Martin Neath and Lamott Oren,
.I
COOL - A C++ Object-Oriented Library,
.R
Information Technology Group, Austin, TX, Internal Original Issue January 1990.
.IP [2]
Mary Fontana, Martin Neath and Lamott Oren,
.I
A Portable Implementation of Parameterized Templates Using A Sophisticated C++
Macro Facility, 
.R
Information Technology Group, Austin, TX, Internal Original Issue January 1990.
.IP [3]
Mary Fontana, Martin Neath and Lamott Oren,
.I
A Portable Exception Handling Mechanism for C++,
.R
Information Technology Group, Austin, TX, Internal Original Issue January 1990.
.IP [4]
Mary Fontana, Martin Neath and Lamott Oren,
.I
Symbols and Packages in C++,
.R
Information Technology Group, Austin, TX, Internal Original Issue January 1990.
.IP [5]
Texas Instruments Incorporated,
.I
COOL User's Guide,
.R
Information Technology Group, Austin, TX, Internal Original Issue January 1990.
.IP [6]
John Interrante and Mark Linton,
.I
Runtime Access to Type Information in C++,
.R
Proceedings of the USENIX C++ Conference, San Francisco, CA, April 9-11, 1990.
.IP [7]
Adele Goldberg and David Robson,
.I
SmallTalk-80: The Language and its Implementation,
.R
1983.
.IP [8]
Guy L. Steele Jr,
.I
Common LISP: The Language,
.R
Second Edition, 1990.

.DS I
----------------------------------------------------------------------------------------------------

Figure 1:  The Symbol class


class Symbol : public Generic {			// Define the Symbol class
  friend class Package;				// Package class needs access
  
protected:
  const char* pname;				// Symbol name
  Generic* val;					// Symbol value
  Association<Symbol*, Generic*>* proplist;	// Property list
  inline Symbol (const char* name);		// Use Package::intern()

public:
  Symbol ();					// Used for constant symbol[]
  ~Symbol();					// Destructor
  Boolean get (const Symbol*, Symbol_GenericP&); // Lookup value
  void put (const Symbol*, Generic*);		// set plist value
  Boolean remove (const Symbol*);		// Remove value from plist
  inline const char* name () CONST;		// Accessor for pname
  inline Generic* value ();			// Accessor for value
  inline Generic* set (Generic*);		// Set new value
  inline Association<Symbol*, Generic*>* plist(); // Accessor for properties
  friend ostream& operator<< (ostream&, const Symbol*);// Print symbol  
  friend ostream& operator<< (ostream&, const Symbol&);// Print symbol  
};
----------------------------------------------------------------------------------------------------
.DE 

.DS I   
----------------------------------------------------------------------------------------------------

Figure 2:  CCC Foo.C and Bar.C


           Foo.C                                     Bar.C


COOLcpp                sym_package.p                         COOLcpp 

                            Symbols.C


          Foo.i           Symbols.i                  Bar.i

 CC                                                                CC
          Foo.o           Symbols.o                  Bar.o 


                           a.out 

----------------------------------------------------------------------------------------------------
.DE   


.DS I
----------------------------------------------------------------------------------------------------

Figure 3:  The Generic class


class Generic {
protected:
  Generic(){};			// Abstract class's have Protected constructors
  virtual Symbol** type_list();
public:
  virtual ~Generic();				// Virtual destructor
  inline Symbol* type_of();		// Return the type symbol
  Boolean is_type_of(Symbol* type);       // Type checking predicate
  int select_type_of(const Symbol** type_vector);
  virtual Boolean map_over_slots(Slot_Mapper procedure, void* rock = NULL);
  virtual void describe(ostream&);	// Display all slots in some "raw" format    
  friend ostream& operator<< (ostream&, const Generic&); // Overload output operator
  friend ostream& operator<< (ostream&, const Generic*); // Overload output operator
  void print(ostream&);				// terse print
};

Symbol* Generic_types[] = {SYM (Generic), NULL};

Symbol** Generic::type_list() CONST {
  return Generic_types;
}

inline Symbol* Generic::type_of() {
  return *(this->type_list());
}

extern Boolean compare_types( Symbol** typelist, Symbol* type);
inline Boolean Generic::is_type_of(Symbol* type) CONST {
  return compare_types(this->type_list(), type);
}

extern int compare_multiple_types(Symbol** type_list, const Symbol** test_types);
inline int Generic::select_type_of(const Symbol** test_types) CONST {
  return compare_multiple_types(this->type_list(), test_types);
}
----------------------------------------------------------------------------------------------------
.DE
