//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/Date_Time.h>			// Include Date_Time class

int main (void) {
  set_default_country (UNITED_STATES);		// Set default country code
  set_default_time_zone (US_CENTRAL);		// Set default time zone
  Date_Time d1;					// Create Date_Time object
  d1.set_local_time ();				// Set current system time
  cout << "Local date/time is: " << d1 << "\n";	// Output date in US format
  d1.set_country (UNITED_KINGDOM);		// Set country to UK
  d1.set_time_zone (GB_EIRE);			// Set Greenwich Mean Time
  cout << "GMT date/time is: " << d1 << "\n";	// Output date/time at GMT
  d1.parse("1 April 1890, 4:30pm");		// Parse some date in UK format
  cout << "Date/time parsed is: " << d1 << "\n";// Output date/time parsed
  d1.set_country (FRANCE);			// Set country to France
  d1.set_time_zone (WET);			// Western European Timezone
  cout << "Date/time in France: " << d1 << "\n";// Output date/time in France
  Date_Time d2;					// Create another object
  d2.set_country (UNITED_STATES);		// Set country to US
  d2.set_time_zone (US_MOUNTAIN);		// Set Mountain Timezone
  d2.set_local_time ();				// Set current system time
  cout << "Date/time set is: " << d2 << "\n";	// Output date in US format
  d2.decr_month (3);				// Move back three months
  cout << "Date/time three months earlier: " << d2 << "\n"; // Output date
  cout << "Duration between dates is ";		// 
  cout << d1.ascii_duration (d2) << "\n";	// Output time duration
  return 0;					// Return valid sucess code
}
