//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 08/31/89 -- Initial design and implementation
// Updated: MJF 03/12/90 -- Added group names to RAISE
//

#include <cool/Base_Vector.h>			// Include the class header
#include <cool/Generic.h>			// Include the class header

// long set_length () -- Set the number of elements in a Vector object.
//                       If there is not enough storage allocated, set to
//                       maximum size for storage.
// Input:                Length, type 
// Output:               Integer representing number of elements

long Vector::set_length (long n, const char* Type) {
#if ERROR_CHECKING
  if (n < 0)					// If index out of range
    RAISE (Error, SYM(Vector), SYM(Negative_Length),
	   "Vector<%s>::set_length(): Negative length %d", Type, n);
#endif
  if (n <= size)				// If not greater than size
    this->number_elements = n;			// Set new length
  else
    this->number_elements = size;		// Else set to maximum possible
  return this->number_elements;			// Return value
}
