//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 04/04/89 -- Initial design and implementation
// Updated: LGO 01/05/90 -- Split into seperate files
//

#include <cool/char.h>		// Include char* specification header file

#if defined(DOS)
extern "C" {
#include <ctype.h>		// Include character processing macros
}
#else
#include <ctype.h>		// Include character processing macros
#endif

// c_capitalize -- Capitalize all words in a string. A word is defined as
//                 a sequence of characters separated by non-alphanumerics
// Input:          Character string
// Output:         Updated string

char* c_capitalize (char* s) {		// Capitalize each word in string
  char* p = s;				// Point to beginning of string
  for (;;) {				// Infinite loop
    for (; *p && !isalnum(*p); p++);	// Skip to first alphanumeric
    if (*p == END_OF_STRING)		// If end of string
      return s;				// Return string
    *p = TO_UPPER(*p);			// Convert character
    while(*++p && isalnum (*p));	// Search for next word
  }
}
