//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// This file is required for all overloaded function names that also have UN*X
// equivalents. This will not be needed for C++ version 2.0
//
// Updated: DKM 07/07/89 -- To work around Xenix 31 char limit:
//                          Shortened is_less_than        to is_lt
//                                    is_greater_than     to is_gt
//                                    is_less_or_equal    to is_le
//                                    is_greater_or_equal to is_ge
//                          Removed is_equal_or_less and is_greater_or_less
//

#ifndef OVERLOADH
#define OVERLOADH
#ifndef __cplusplus

overload strlen;
overload strcat;
overload strncat;
overload strcmp; 
overload strncmp;
overload strcpy; 
overload strchr; 
overload strrchr;
overload strncpy;

overload atof;
overload atol;
overload atoi;

overload double strtod (const char*, char**);
overload long   strtol (const char*, char**, int);

overload reverse;
overload trim;
overload left_trim;
overload right_trim;
overload upcase;
overload downcase;
overload capitalize;

#if !defined(DOS) && !defined(M_XENIX)
extern reverse ();
extern trim ();
extern left_trim ();
extern right_trim ();
extern upcase ();
extern downcase ();
extern capitalize ();
#endif

#if defined(DOS)
extern "C" {
#include <stdio.h>
}
#elif !defined(M_XENIX)
#include <stdio.h>
#endif

#endif _cplusplus
#endif OVERLOADH
