//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: LGO 05/22/89 -- Initial design and implementation
// Updated: MBN 09/16/89 -- Added conditional exception handling
//

#include <cool/Package.h>

// intern -- Only public method for user to add a new symbol to package. This
//           method always returns symbol (creates if not found)
// Input:    Pointer to symbol name
// Output:   Symbol

Symbol* Package::intern(const char* name) {
  if (this->find (name))			// If symbol already exist
    return this->value();			// Return symbol value
  else {
    Symbol* result = new Symbol(name);		// Else create new symbol
    this->Hash_Table<char*, Symbol*>::put(name, result); // Add to package
    return result;				// Return created symbol
  }
}
