//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/List.h>
#include <test.h>

DECLARE List<int>;

void list_int_curpos_test1() {
  List<int> l1(3,11,22,33);
  List<int> ltemp1;

  TEST_RUN("l1.next()",l1.next(), l1.value(), 11);
  
  ltemp1 = List<int>(4,11,55,22,33);
  TEST_RUN("l1.insert_after(55)", l1.insert_after(55),
	   (l1.value()==55 && l1==ltemp1), TRUE);

  TEST_RUN("l1.prev()",l1.prev(),l1.value(), 11);

  ltemp1 = List<int>(5,66,11,55,22,33);
  TEST_RUN("l1.insert_before(66)", l1.insert_before(66), 
	   (l1.value()==66 && l1==ltemp1), TRUE);

  ltemp1 = List<int>(4,11,55,22,33);
  TEST("l1.remove()", (l1.remove()==66 && l1.value()==11 && l1==ltemp1), TRUE);

  ltemp1 = List<int>(3,11,55,33);
  TEST_RUN("l1.remove()", l1.next();l1.next(), 
	   (l1.remove()==22 && l1.value()==33 && l1==ltemp1), TRUE);

  TEST_RUN("l1.position()", l1.prev(), (l1.position()==1 && l1.value()==55),
	   TRUE);
}

void list_int_curpos_test2() {
  List<int> l1(3,11,55,33);
  List<int> l2(4,55,66,33,22);
  List<int> ltemp1;

  TEST_RUN("l1.next_lunion(l2)", l1.reset(),
	   (l1.next_lunion(l2) && l1.value()==11), TRUE);
  TEST_RUN("l1.next_lunion(l2)", l1.next_lunion(l2);l1.next_lunion(l2),
	   (l1.next_lunion(l2) && l1.value()==66), TRUE);
  TEST("l1.next_lunion(l2)", (l1.next_lunion(l2) && l1.value()==22),TRUE);
  TEST("l1.next_lunion(l2)", l1.next_lunion(l2), FALSE);

  TEST_RUN("l1.next_intersection(l2)", l1.reset(), 
	   (l1.next_intersection(l2) && l1.value()==55),  TRUE);
  TEST("l1.next_intersection(l2)", 
       (l1.next_intersection(l2) && l1.value()==33), TRUE);
  TEST("l1.next_intersection(l2)", l1.next_intersection(l2), FALSE);
  TEST_RUN("l1.next_difference(l2)", l1.reset(), 
	   (l1.next_difference(l2) && l1.value()==11), TRUE);
  TEST("l1.next_difference(l2)", l1.next_difference(l2), FALSE);
  l1.reset();
  TEST_RUN("l1.next_exclusive_or(l2)", l1.reset(), 
	   (l1.next_exclusive_or(l2) && l1.value()==11), TRUE);
  TEST_RUN("l1.next_exclusive_or(l2)", l1.next_exclusive_or(l2), 
	   (l1.next_exclusive_or(l2) && l1.value()==22), TRUE);
  TEST("l1.next_exclusive_or(l2)", l1.next_exclusive_or(l2), FALSE);
}

void list_int_currentpos_test() {
  list_int_curpos_test1();
  list_int_curpos_test2();
}
