//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: DKM 07/24/90 -- Initial implementation

#include <cool/Generic.h>
#include <cool/Base_Hash.h>

// statistics -- Make a pass through the Hash Table and print out statistics
//               for the number of entries in each bucket.
// Input:   this*
// Output   None

void Hash_Table::statistics () {
  long arry[BUCKET_SIZE+1];
  char str[30];
  float pct_full;
  for (int i = 0; i <= BUCKET_SIZE; i++)
    arry[i]=0;
  long buckets = get_bucket_count();
  long total_slots = buckets * BUCKET_SIZE;

  for (i = 0; i < buckets; i++) 		// For each bucket
    arry[this->items_in_buckets[i] ]++; 	//  Bump array per slots used

  // Print out general info
  pct_full = (float)(entry_count*100.0) / (float)total_slots;
  sprintf(str,"%.1f",pct_full);                 
  cout << "\n" << buckets << " Buckets, " << BUCKET_SIZE << " slots each = "
     << total_slots << " slots available.  " << entry_count << " slots used ("
     << str << "%)\n";

  if(entry_count > 0) {                        // Print out slot usage
    cout << "  Distribution of buckets with n slots filled:\n";
    for (i = 0; i <= BUCKET_SIZE; i++) {
      pct_full = (float)(arry[i]*100) / (float)buckets;
      sprintf(str,"%.1f",pct_full);
      cout << i << "=" << str << "% ";
    }
    cout << "\n\n";
  }
}
