
PreDraw::usage = "PreDraw[f] prepares the figure f for drawing."

PreDraw @ Point[{x_, y_}] := Point[{x, y}]

PreDraw @ Point[{x_, y_, z_}] := Point[{x, y}]

PreDraw @ Line @ h_ := Line[Take[#, 2] & /@ h] 

( PreDraw @ Polygon @ h_ := Block[
	{l = Take[#, 2] & /@ h},
	{Polygon[l], RGBColor[0, 0, 0], Line[Append[l, First @ l]]} ] )

( PreDraw @ Circle[c_, r_] := 
	PreDraw @ Line @ Map[c + r (Cos[#] $i + Sin[#] $j) &, 
	2 N[Pi] Range[0, 1, 1 / $PointsOnCircle]] )

PreDraw @ u_Circle3D := PreDraw @ PreDraw3D @ u

PreDraw @ w_Plane := PreDraw @ PreDraw3D @ w

PreDraw @ Sphere[{a_, b_, c_}, r_] := PreDraw @ Circle[{a, b, 0}, r] 

( PreDraw @ d_Disk := Block[
	{c = PreDraw[Circle @@ d]},
	{Polygon @@ c, RGBColor[0, 0, 0], c} ] )

( PreDraw[m_] := m 
	/; MemberQ[{GrayLevel, RGBColor, PointSize, AbsolutePointSize,
	Thickness, AbsoluteThickness, Dashing}, Head @ m] )

PreDraw @ Text[x_, c_, d___] := Text[x, Take[c, 2], d]

PreDraw @ EdgeForm[___] := {}

PreDraw @ h_List := PreDraw /@ h

