
PolarTiles::usage = "PolarTiles[{r0, r1, dr}, {t0, t1, dt}, s] gives a list of 
quadrilaterals of side s with corners at the points with r-coordinates running 
from r0 to r1 in steps of dr and t-coordinates running from t0 to t1 in steps 
of dt."

( PolarTiles[{r0_, r1_, dr_}, {t0_, t1_, dt_}, s_] := Map[Polygon, 
	Thread[Flatten[#, 1]& /@ {
		PolarTriples[{r0 - s/2 dr, r1 - s/2 dr, dr}, 
			{t0 - s/2 dt, t1 - s/2 dt, dt}],
		PolarTriples[{r0 + s/2 dr, r1 + s/2 dr, dr}, 
			{t0 - s/2 dt, t1 - s/2 dt, dt}],
		PolarTriples[{r0 + s/2 dr, r1 + s/2 dr, dr}, 
			{t0 + s/2 dt, t1 + s/2 dt, dt}],
		PolarTriples[{r0 - s/2 dr, r1 - s/2 dr, dr}, 
			{t0 + s/2 dt, t1 + s/2 dt, dt}]
	} ]
] )

