
Circumcircle::usage = "Circumcircle[{p, q, r}] is the circle through the 
points p, q and r; it may degenerate into a line, which will be stretched to 
have length 1000."

( Circumcircle @ {p_, q_, r_} := Stretch[Line[{p, r}], $Infinity]
	/; CollinearQ @ {p, q, r} )

( Circumcircle @ {p_, q_, r_} := 
	Circle[#, Distance[#, p]] & [Circumcentre @ {p, q, r}]
	/; Last @ p == 0 && Last @ q == 0 && Last @ r == 0 )

( Circumcircle @ {p_, q_, r_} := Block[
	{n, x, a, c, s},
	n = Cross[q - p, r - p];
	x = Line @ {$o, Cross[n, $k]};
	a = Angle[n, $k];
	c = Circumcentre @ Rotate[a, x] @ {$o, q - p, r - p};
	s = Distance[c, $o];
	Translate[p] @ Rotate[-a, x] @ Circle3D[c, c + s $i, c + s $j]
	]
	/; Not[Last @ p == 0 && Last @ q == 0 && Last @ r == 0]  )




