
Circumcentre::usage = "Circumcentre[{p, q, r}] is the centre of the circle 
through the points p, q and r. Circumsphere[{p, q, r, s}] is the centre of the 
sphere through the points p, q, r and s." 

Circumcentre @ {p_, p_, p_} := p

( Circumcentre @ {p_, q_, r_} := {}
	/; CollinearQ @ {p, q, r} )

( Circumcentre @ {p_, q_, r_} := 
	Meet[
		RightBisector @ Line @ {p, q}, 
		RightBisector @ Line @ {q, r} ]
	/; Last @ p == 0 && Last @ q == 0 && Last @ r == 0 
	&& Not[CollinearQ @ {p, q, r}] )

( Circumcentre @ {p_, q_, r_} := 
	Meet3D[
		Plane @ {p, q, r},
		PlaneRightBisector[Line @ {p, q}],
		PlaneRightBisector[Line @ {p, r}] ] 
	/; Not[Last @ p == 0 && Last @ q == 0 && Last @ r == 0] 
	&& Not[CollinearQ @ {p, q, r}] )

( Circumcentre @ {p_, q_, r_, s_} := Block[
	{u, v, w, c},
	u = PlaneRightBisector[Line @ {p, q}];
	v = PlaneRightBisector[Line @ {q, r}];
	w = PlaneRightBisector[Line @ {r, s}];
	Meet3D[u, v, w] ] )

