/*****************************************************************************
* Setting attributes for geometric objects.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
*****************************************************************************/

#ifndef ATTRIBUTE_H
#define ATTRIBUTE_H

#include "iritprsr.h"
#include "miscattr.h"

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

void AttrSetObjectColor(IPObjectStruct *PObj, int Color);
int AttrGetObjectColor(IPObjectStruct *PObj);
void AttrSetObjectRGBColor(IPObjectStruct *PObj, int Red, int Green, int Blue);
int AttrGetObjectRGBColor(IPObjectStruct *PObj,
			  int *Red,
			  int *Green,
			  int *Blue);

void AttrSetObjectIntAttrib(IPObjectStruct *PObj, char *Name, int Data);
int AttrGetObjectIntAttrib(IPObjectStruct *PObj, char *Name);

void AttrSetObjectRealAttrib(IPObjectStruct *PObj, char *Name, RealType Data);
RealType AttrGetObjectRealAttrib(IPObjectStruct *PObj, char *Name);

void AttrSetObjectPtrAttrib(IPObjectStruct *PObj, char *Name, VoidPtr Data);
VoidPtr AttrGetObjectPtrAttrib(IPObjectStruct *PObj, char *Name);

void AttrSetObjectStrAttrib(IPObjectStruct *PObj, char *Name, char *Data);
char *AttrGetObjectStrAttrib(IPObjectStruct *PObj, char *Name);

void AttrSetObjectObjAttrib(IPObjectStruct *PObj,
			    char *Name,
			    IPObjectStruct *Data,
			    int CopyData);
void AttrSetObjAttrib(IPAttributeStruct **Attrs,
		      char *Name,
		      IPObjectStruct *Data,
		      int CopyData);
IPObjectStruct *AttrGetObjectObjAttrib(IPObjectStruct *PObj, char *Name);
IPObjectStruct *AttrGetObjAttrib(IPAttributeStruct *Attrs, char *Name);

IPAttributeStruct *AttrCopyOneAttribute(IPAttributeStruct *Src);
IPAttributeStruct *AttrCopyAttributes(IPAttributeStruct *Src);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* ATTRIBUTE_H */
