/* reformat.h
 * Global definitions and constants for the NCSA file conversion routines.
 *
 * Peter Webb, Summer 1990
 */

/* Prevent multiple inclusion of this file */

#ifndef reformat_h
#define reformat_h

/* Constants */

#define BUF_SIZE 1024       /* Buffer size */
#define FILE_SIZE 255       /* Maximum size of a file name */
#define LINE_SIZE 255       /* Maximum size of a single line */
#define MAX_ARGS 20         /* Argument list size */
#define ROOT_DIR "."        /* Root directory */
#define HELP_FILE "help.txt" /* Help file name */
#define VERSION "NCSA Reformat Version 1.0"  /* Welcome message */
#define WELCOME "Welcome to Reformat.\nPlease select a conversion operation.\n"

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif
#ifndef NULL
#define NULL 0
#endif

/* The classname of the application */

#define APP_CLASS "XReformat"

/* Directory containing the Xrm application DB */

#define XDB_ROOT "./"      

#define XDB_SIZE 255        /* Maximum size of a database name */

/* Macro to return the current directory, as a string */

#define CUR_DIR(path) ((char *)getwd(path))

/* For getting 16-bit values */

#define SHORT(ptr) (((*(ptr)) << 8) | (*((ptr)+1)))

/* For getting 32-bit values */

#define LONG(ptr) ( ((*(ptr)) << 24) | ((*((ptr)+1)) << 16) | \
		     ((*((ptr)+2)) << 8) | (*((ptr)+3)) )

#endif /* reformat_h */

