/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.der;

import gnu.crypto.der.BitString;
import gnu.crypto.der.DER;
import gnu.crypto.der.DEREncodingException;
import gnu.crypto.der.DERValue;
import gnu.crypto.der.OID;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class DERReader
implements DER {
    private InputStream in;
    private final ByteArrayOutputStream encBuf;

    public static final DERValue read(byte[] encoded) throws IOException {
        return new DERReader(encoded).read();
    }

    public final void skip(int bytes) throws IOException {
        this.in.skip(bytes);
    }

    public final DERValue read() throws IOException {
        int tag = this.in.read();
        if (tag == -1) {
            throw new EOFException();
        }
        this.encBuf.write(tag);
        int len = this.readLength();
        DERValue value = null;
        if ((tag & 0x20) == 32) {
            this.in.mark(2048);
            byte[] encoded = new byte[len];
            this.in.read(encoded);
            this.encBuf.write(encoded);
            value = new DERValue(tag, len, CONSTRUCTED_VALUE, this.encBuf.toByteArray());
            this.in.reset();
            this.encBuf.reset();
            return value;
        }
        switch (tag & 0xC0) {
            case 0: {
                value = new DERValue(tag, len, this.readUniversal(tag, len), this.encBuf.toByteArray());
                this.encBuf.reset();
                break;
            }
            case 128: {
                byte[] encoded = new byte[len];
                this.in.read(encoded);
                this.encBuf.write(encoded);
                value = new DERValue(tag, len, encoded, this.encBuf.toByteArray());
                this.encBuf.reset();
                break;
            }
            case 64: {
                throw new DEREncodingException("non-constructed APPLICATION data");
            }
            default: {
                throw new DEREncodingException("PRIVATE class not supported");
            }
        }
        return value;
    }

    private final Object readUniversal(int tag, int len) throws IOException {
        byte[] value = new byte[len];
        this.in.read(value);
        this.encBuf.write(value);
        switch (tag & 0x1F) {
            case 1: {
                if (value.length != 1) {
                    throw new DEREncodingException();
                }
                boolean bl = false;
                if (value[0] != 0) {
                    bl = true;
                }
                return bl;
            }
            case 5: {
                if (len != 0) {
                    throw new DEREncodingException();
                }
                return null;
            }
            case 2: 
            case 10: {
                return new BigInteger(value);
            }
            case 3: {
                byte[] bits = new byte[len - 1];
                System.arraycopy(value, 1, bits, 0, bits.length);
                return new BitString(bits, value[0] & 0xFF);
            }
            case 4: {
                return value;
            }
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                return DERReader.makeString(tag, value);
            }
            case 23: 
            case 24: {
                return this.makeTime(tag, value);
            }
            case 6: {
                return new OID(value);
            }
            case 13: {
                return new OID(value, true);
            }
        }
        throw new DEREncodingException("unknown tag " + tag);
    }

    private final int readLength() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            throw new EOFException();
        }
        this.encBuf.write(i);
        if ((i & 0xFFFFFF80) == 0) {
            return i;
        }
        if (i < 255) {
            byte[] octets = new byte[i & 0x7F];
            this.in.read(octets);
            this.encBuf.write(octets);
            return new BigInteger(1, octets).intValue();
        }
        throw new DEREncodingException();
    }

    private static final String makeString(int tag, byte[] value) throws IOException {
        switch (tag & 0x1F) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                return DERReader.fromIso88591(value);
            }
            case 28: 
            case 30: {
                return DERReader.fromUtf16Be(value);
            }
            case 12: {
                return DERReader.fromUtf8(value);
            }
        }
        throw new DEREncodingException("unknown string tag");
    }

    private static final String fromIso88591(byte[] bytes) {
        StringBuffer str = new StringBuffer(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            str.append((char)(bytes[i] & 0xFF));
            ++i;
        }
        return str.toString();
    }

    private static final String fromUtf16Be(byte[] bytes) throws IOException {
        if ((bytes.length & 1) != 0) {
            throw new IOException("UTF-16 bytes are odd in length");
        }
        StringBuffer str = new StringBuffer(bytes.length / 2);
        int i = 0;
        while (i < bytes.length) {
            char c = (char)(bytes[i] << 8 & 0xFF);
            c = (char)(c | (char)(bytes[i + 1] & 0xFF));
            str.append(c);
            i += 2;
        }
        return str.toString();
    }

    private static final String fromUtf8(byte[] bytes) throws IOException {
        StringBuffer str = new StringBuffer((int)((double)bytes.length / 1.5));
        int i = 0;
        while (i < bytes.length) {
            char c = '\u0000';
            if ((bytes[i] & 0xE0) == 224) {
                if (i + 2 >= bytes.length) {
                    throw new IOException("short UTF-8 input");
                }
                c = (char)((bytes[i++] & 0xF) << 12);
                if ((bytes[i] & 0x80) != 128) {
                    throw new IOException("malformed UTF-8 input");
                }
                c = (char)(c | (char)((bytes[i++] & 0x3F) << 6));
                if ((bytes[i] & 0x80) != 128) {
                    throw new IOException("malformed UTF-8 input");
                }
                c = (char)(c | (char)(bytes[i++] & 0x3F));
            } else if ((bytes[i] & 0xC0) == 192) {
                if (i + 1 >= bytes.length) {
                    throw new IOException("short input");
                }
                c = (char)((bytes[i++] & 0x1F) << 6);
                if ((bytes[i] & 0x80) != 128) {
                    throw new IOException("malformed UTF-8 input");
                }
                c = (char)(c | (char)(bytes[i++] & 0x3F));
            } else if ((bytes[i] & 0xFF) < 128) {
                c = (char)(bytes[i++] & 0xFF);
            } else {
                throw new IOException("badly formed UTF-8 sequence");
            }
            str.append(c);
        }
        return str.toString();
    }

    private final Date makeTime(int tag, byte[] value) throws IOException {
        String str;
        Calendar calendar = Calendar.getInstance();
        String date = str = DERReader.makeString(19, value);
        String tz = "";
        if (str.indexOf("+") > 0) {
            date = str.substring(0, str.indexOf("+"));
            tz = str.substring(str.indexOf("+"));
        } else if (str.indexOf("-") > 0) {
            date = str.substring(0, str.indexOf("-"));
            tz = str.substring(str.indexOf("-"));
        } else if (str.endsWith("Z")) {
            date = str.substring(0, str.length() - 2);
            tz = "Z";
        }
        if (!tz.equals("Z") && tz.length() > 0) {
            calendar.setTimeZone(TimeZone.getTimeZone(tz));
        } else {
            calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        if ((tag & 0x1F) == 23) {
            if (date.length() < 10) {
                throw new DEREncodingException("cannot parse date");
            }
            try {
                int year = Integer.parseInt(str.substring(0, 2));
                year = year < 50 ? (year += 2000) : (year += 1900);
                calendar.set(year, Integer.parseInt(str.substring(2, 4)) - 1, Integer.parseInt(str.substring(4, 6)), Integer.parseInt(str.substring(6, 8)), Integer.parseInt(str.substring(8, 10)));
                date.length();
                calendar.set(13, Integer.parseInt(str.substring(10, 12)));
            }
            catch (NumberFormatException nfe) {
                throw new DEREncodingException("cannot parse date");
            }
        }
        if (date.length() < 10) {
            throw new DEREncodingException("cannot parse date");
        }
        try {
            calendar.set(Integer.parseInt(date.substring(0, 4)), Integer.parseInt(date.substring(4, 6)) - 1, Integer.parseInt(date.substring(6, 8)), Integer.parseInt(date.substring(8, 10)), 0);
            switch (date.length()) {
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    calendar.set(14, Integer.parseInt(date.substring(15)));
                }
                case 14: {
                    calendar.set(13, Integer.parseInt(date.substring(12, 14)));
                }
                case 12: {
                    calendar.set(12, Integer.parseInt(date.substring(10, 12)));
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new DEREncodingException("cannot parse date");
        }
        return calendar.getTime();
    }

    public DERReader(byte[] in) {
        this(new ByteArrayInputStream(in));
    }

    public DERReader(byte[] in, int off, int len) {
        this(new ByteArrayInputStream(in, off, len));
    }

    public DERReader(InputStream in) {
        this.in = !in.markSupported() ? new BufferedInputStream(in, 16384) : in;
        this.encBuf = new ByteArrayOutputStream(2048);
    }
}

