/*
 * Copyright (C) 2002, 2013 Free Software Foundation, Inc.
 *
 * This file is part of GNU Classpath Extensions (classpathx).
 * For more information please visit https://www.gnu.org/software/classpathx/
 *
 * classpathx is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * classpathx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with classpathx.
 * If not, see <http://www.gnu.org/licenses/>.
 */
package javax.servlet.jsp;

/**
 * A tag handler specific exception.
 * @version 2.1
 * @author Nic Ferrier (nferrier@tapsellferrier.co.uk)
 */
public class JspTagException
    extends JspException
{

    /**
     * New exception with no message.
     */
    public JspTagException()
    {
    }

    /**
     * New exception with the specified message.
     */
    public JspTagException(String message)
    {
        super(message);
    }

    /**
     * New exception with the specified message and cause.
     */
    public JspTagException(String message, Throwable cause)
    {
        super(message, cause);
    }

    /**
     * New exception with the specified cause.
     */
    public JspTagException(Throwable cause)
    {
        super(cause);
    }

}
