/*	$NetBSD: whois.c,v 1.7 1997/10/20 03:23:38 lukem Exp $	*/

/*
 */

#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <portlib.h>

#define	NICHOST	"whois.internic.net"

int main __P((int, char **));
static void usage __P((void));

int
main(argc, argv)
	int argc;
	char **argv;
{
	extern char *optarg;
	extern int optind;
	FILE *sfi, *sfo;
	int ch;
	struct sockaddr_in sin;
	struct hostent *hp;
	struct servent *sp;
	int s;
	char *host;

	host = NICHOST;
	while ((ch = getopt(argc, argv, "h:")) != -1)
		switch((char)ch) {
		case 'h':
			host = optarg;
			break;
		case '?':
		default:
			usage();
		}
	argc -= optind;
	argv += optind;

	if (!argc)
		usage();

	hp = gethostbyname(host);
	if (hp == NULL)
		printf("Error with host");
	host = hp->h_name;
	s = socket(hp->h_addrtype, SOCK_STREAM, 0);
	if (s < 0)
		printf("socket");
	memset((caddr_t)&sin, 0, sizeof (sin));
	sin.sin_family = hp->h_addrtype;
	if (bind(s, (struct sockaddr *)&sin, sizeof(sin)) < 0)
		printf("bind");
	memmove((char *)&sin.sin_addr, hp->h_addr, hp->h_length);
	sp = getservbyname("whois", "tcp");
	if (sp == NULL)
		printf("whois/tcp: unknown service");
	sin.sin_port = sp->s_port;
	if (connect(s, (struct sockaddr *)&sin, sizeof(sin)) < 0)
		printf("connect");
	sfi = fdopen(s, "r");
	sfo = fdopen(s, "w");
	if (sfi == NULL || sfo == NULL)
		printf("fdopen");
	while (argc-- > 1)
		(void)fprintf(sfo, "%s ", *argv++);
	(void)fprintf(sfo, "%s\r\n", *argv);
	(void)fflush(sfo);
	while ((ch = getc(sfi)) != EOF)
		putchar(ch);
	exit(0);
}

static void
usage()
{
	(void)fprintf(stderr, "usage: whois [-h hostname] name ...\n");
	exit(1);
}
