;# NAME
;#    strings1.pl - FUN with strings #1
;#
;# NOTES
;#    I wrote Format_Text_Block when I just started programming Perl so
;#    it is probably not very Perlish code. Center is more like it :-).
;#
;# AUTHOR
;#    Michael S. Muegel (mmuegel@mot.com)
;#
;# RCS INFORMATION
;#    mmuegel
;#    /usr/local/ustart/src/mail-tools/dist/foo/libs/strings1.pl,v 1.1 1993/07/28 08:07:19 mmuegel Exp

package strings1;

;###############################################################################;# Center
;#
;# Center $Text assuming the output should be $Columns wide. $Text can span
;# multiple lines, of course :-). Lines within $Text that contain only 
;# whitespace are not centered and are instead collapsed. This may save time 
;# when printing them later.
;#
;# Arguments:
;#    $Text, $Columns
;#
;# Returns:
;#    $Centered_Text
;###############################################################################
sub main'Center
{
   local ($_, $Columns) = @_;
   local ($*) = 1;

   s@^(.*)$@" " x (($Columns - length ($1)) / 2) . $1@eg;
   s/^[\t ]*$//g;
   return ($_);
};

;###############################################################################
;# Format_Text_Block
;#
;# Formats a text string to be printed to the display or other similar device.
;# Text in $String will be fomratted such that the following hold:
;#
;#    + $String contains the (possibly) multi-line text to print. It is
;#	automatically word-wrapped to fit in $Columns. 
;#
;#    + \n'd are maintained and are not folded.
;#
;#    + $Offset	is pre-pended before each separate line of text. 
;#
;#    + If $Offset_Once	is $TRUE $Offset will only appear on the first line.
;#      All other lines will be indented to match the amount of whitespace of
;#      $Offset.
;#
;#    + If $Bullet_Indent is $TRUE $Offset will only be applied to the begining
;#      of lines as they occured in the original $String. Lines that are created
;#      by this routine will always be indented by blank spaces.
;#
;#    + If $Columns is 0 no word-wrap is done. This might be useful to still
;#      to offset each line in a buffer.
;#
;#    + If $Split_Expr is supplied the string is split on it. If not supplied
;#      the string is split on " \t\/\-\,\." by default.
;#
;#    + If $Offset_Blank is $TRUE then empty lines will have $Offset pre-pended
;#      to them. Otherwise, they will still empty.
;#
;# This is a realy workhorse routine that I use in many places because of its
;# veratility.
;#
;# Arguments:
;#    $String, $Offset, $Offset_Once, $Bullet_Indent, $Columns, $Split_Expr,
;#    $Offset_Blank
;#
;# Returns:
;#    $Buffer
;###############################################################################
sub main'Format_Text_Block
{
   local ($String, $Real_Offset, $Offset_Once, $Bullet_Indent, $Columns, 
      $Split_Expr, $Offset_Blank) = @_;

   local ($New_Line, $Line, $Chars_Per_Line, $Space_Offset, $Buffer,
      $Next_New_Line, $Num_Lines, $Num_Offsets, $Offset);
   local ($*) = 0;
   local ($BLANK_TAG) = "__FORMAT_BLANK__";
   local ($Blank_Offset) = $Real_Offset if ($Offset_Blank);

   # What should we split on?
   $Split_Expr = " \\t\\/\\-\\,\\." if (! $Split_Expr);

   # Pre-process the string - convert blank lines to __FORMAT_BLANK__ sequence
   $String =~ s/\n\n/\n$BLANK_TAG\n/g;
   $String =~ s/^\n/$BLANK_TAG\n/g;
   $String =~ s/\n$/\n$BLANK_TAG/g;

   # If bad $Columns/$Offset combo or no $Columns make a VERRRYYY wide $Column
   $Offset = $Real_Offset;
   $Chars_Per_Line = 16000 if (($Chars_Per_Line = $Columns - length ($Offset)) <= 0);
   $Space_Offset = " " x length ($Offset);

   # Get a buffer
   foreach $Line (split ("\n", $String))
   {
      $Offset = $Real_Offset if ($Bullet_Indent);

      # Find where to split the line
      if ($Line ne $BLANK_TAG)
      { 
         $New_Line = "";
         while ($Line =~ /^([$Split_Expr]*)([^$Split_Expr]+)/)
         {
            if (length ("$New_Line$&") >= $Chars_Per_Line)
            {
               $Next_New_Line = $+;
               $New_Line = "$Offset$New_Line$1";
               $Buffer .= "\n" if ($Num_Lines++);
               $Buffer .= $New_Line;
               $Offset = $Space_Offset if (($Offset) && ($Offset_Once));
               $New_Line = $Next_New_Line;
               ++$Num_Lines;
            }
            else
            {
               $New_Line .= $&;
            };
            $Line = $';
         };

         $Buffer .= "\n" if ($Num_Lines++);
         $Buffer .= "$Offset$New_Line$Line";
         $Offset = $Space_Offset if (($Offset) && ($Offset_Once));
      }

      else
      {
         $Buffer .= "\n$Blank_Offset";
      };
   };

   return ($Buffer);

};

1;
