This is PL 1 of a port of Sun RPC 4.0 to Mint and MintNet >= 0.55.

Installation:
-------------

There is a complete installation in installdir, which looks like
an *x root directory. You should put the files from installdir
to the appropriate directories in your root dir, ie do the
equivalent of:
	cd installdir; cp -R * /

If you can recompile all the stuff then you can issue
	make DESTDIR=/
in the top level directory.


Notes:
------

You must start /etc/portmap before inetd. You should get inetd-02.tgz,
which contains an inetd that is able to start rpc services on demand.

Note that rpc services run on demand by inetd must be compiled with
rpcgen -0 (rpc.rstatd is compiled this way) and need some extra
coding to make them exit if they have been idle for some time.

I have changed the demo/dir example this way. Have a look at the changes,
they are #ifdef DYNAMIC.

Also note that servers created this way should always be marked as multi-
threaded in /etc/inetd.conf by writing 'wait' as flags. A line for rc.rstatd
would look like this:

rstat/1-3 dgram rpc/udp wait root /usr/etc/rpc.rstatd rpc.rstatd

'rstat' is the name of the rpc service which must be in /etc/rpc. If this
name also occures in /etc/services (as for nfsd) then inetd will use the
port specified in /etc/services (2049 for nfsd). This feature was intruduced
by me and is nonstandard but allows for a 'load on demand' nfs server. (Note
that the nfsd/mountd from nfs-042.tgz cannot be used this way--however, I have
patches to make them work with inetd; they will be part of 0.43+).

1-3 are the version numbers of the rpc service. rpc/udp is the transport that
should be used.
 
rpc/tcp will not work work with MintNet 0.55 due to a bug in MintNet.
(listen() on an already listening socket should not fail. To fix this
change the test "if (tcb->state != TCBS_CLOSED)" into
"if (tcb->state > TCBS_LISTEN)" in net/inet/tcp.c:tcp_listen().)

If you compile the services without -0 then you must run the servers in the
background, for instance for the demo/dir example you would say:
	dir_svc&

For the demo/dir example you must undefine DYNAMIC in the Makefile for this
to work.


Changes:
--------

*** PL 2:
	- reenabled tcp in portmap, rpcinfo, rpcgen, demo/*
	- made rpc.rstatd gather more useful statistics (using
	  Suptime and some net ioctl's).
	- made rpc.rstatd exit when idle (for use with new inetd).
	- added -0 option to rpcgen (read above notes)

*** PL 1:
	- removed the patches to get along without net/if.h
	  introduced in PL 0. MintNet as of 0.3 has real net
	  interfaces.

*** PL 0:

doc/:
	- No changes, of course. You will need groff or another `real'
	  nroff+pic+eqn+tbl plus a working tmac.s macro package.
	  Tell we if you want me to include preformatted versions.

etc/:
	- Made portmap ignore TCP requests (otherwise it will complain
	  about not beeing able to create a TCP client and exit).
	- Changed a fork() into __fork_and_exit().
	- Changed `rpcinfo -p' (dump services) to use UDP instead of TCP.
	- Set the stacksize of portmap and rpcinfo to 16k. Without this (eg
	  _stksize = 0) they will crash when broadcasting (rpcinfo -b).
	- BTW: It is always a good idea to set the stacksize to at least 8k
	  when using rpc/xdr stuff, especially when the name resolver is
	  invoked (as with get_myaddress()), since some xdr routines are
	  recursive and therefore need lots of stack space. If your programs
	  crash try increasing the stack first.

rpc/:
	- Serveral hacks to get rid of the net interface stuff in
	  net/if.h. This can be changed back when MintNet gets real
	  net interfaces. (Use the nameserver for get_myaddress() instead
	  of looping through the net interfaces. Use INADDR_BROADCAST as
	  the broadcast address instead of looping trough the net interfaces.)
	- Use O_NDELAY nonblocking mode instead of using FIONBIO.
	- Fixed a bug in clnttcp_create() which caused a bind(-1, ...)
	  to be done.
	- Changed clnt_spcreateerror() to make it display messages for
	  the socket related errors instead of error numbers.

rpcgen/:
	- Fixed a bug in rpc_parse.c:def_program() which caused unter-
	  minated linked lists -> crash.
	- Configured to generate UDP code by default.
	- Changed so that it loads the preprocessor from $(GCCEXEC)cpp
	  or from /usr/lib/cpp if GCCEXEC is not set.
	- Added code to check for memory allocation failures (the original
	  sources did not check whether malloc() returned 0)

rpcsvc/:
	All the stuff except the files dealing with rstat/rstatd are
	unchanged. rstatd/rstat work, but rstatd produces very bogus
	output:
	- boottime is the time when rstatd was started
	- havedisk is true when there are any drives C...P
	- current time works ok :)
	- swap in/out, page in/out are correct (zero for MiNT)
	- all other infos (load avg, # net if's, xfer, # contex
	  switches, # interrupts, ...) are always zero

demo/:
	- Configured the demos to use UDP.
	- Set stacksize of dir/{dir_svc, rls} to 16k.

Compilation:
------------

I used gcc 2.4.5 to compile and loaded MintLib PL 43, Socket Lib 0.55,
and Portlib PL 08.

Note that Portlib is NOT part of this distribution.

Bugs:
-----

- If you do an `rpcinfo -b portmapper 2' (broadcast to portmapper, version 2),
  you won't get responses from the local machines portmapper.
  This is because of MiNT's blocking fork(). Have a look at portmap.c:callit()
  to understand why.

Enjoy and please report any bugs you encounter...
Ports of rpc services (rex, spray, yp, ...) are also welcome.

Kay Roemer,
roemer@hera.rbi.informatik.uni-frankfurt.de
