/*
 * Copyright (c) 1994/95 jerry g geiger
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms.
 * This program my not be sold in any way!
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * This program's code is based on ftp-client code 
 * ftp Copyright (c) 1985, 1989 Regents of the University of California.
 *
 *
 * pop3 according rfc 1725
 */

#ifdef SCCS
static char sccsid[] = "@(#)cmdtab.c, pop3 (j.g.geiger) 3/12/95";
#endif

#include "pop3.h"


/*
 * User pop3 -- Command Table.
 */
#if 0
	/* see pop3.h for decls and cmds.c for funcs	*/
 	/* internal	*/
int	setbell(), setdebug();
int	setverbose();
int setautodeliver();
int	help();
int	showstatus();
int deliver();
int printlist();
int	quit();		/* --> QUIT, exit()	*/

	/* no connection	*/
int	setpeer();		/* "open" enters AUTHORIZATION State, 
						replied by a greeting	*/
	/* AUTHORIZATION & TRANSACTION State */
int	disconnect();	/* "close" QUIT	*/
	/* AUTHORIZATION State */
int usrpass();			/* USER, PASS */
int apop();		/* APOP */
	/* TRANSACTION state	*/
int sethost();			/* HOST: use host's mailbox	*/
int getstatus();	/* STAT: drop listing	*/
int list();			/* LIST: scan listing	*/
int last();			/* LAST	*/
int	retrieve();		/* "get" RETR 	*/
int	delete();		/* DELE	*/
int	reset();		/* RSET	*/
int top();			/* TOP	*/
int uidl();			/* UIDL */
int getall();	/* "dropmails" --> RETR, DELE for all mails	*/

#endif

static char	*apophelp[] = {	"<name> [<secret>]",
					  "specify name & secret for maildrop access"};
static char	*autodeliverhelp[] = {"[on]", "toggle/set: auto-deliver mode"};
static char	*beephelp[] = {"[on]",
				"toggle/set: beep after retrieve, deliver and\n"
				"\t multi-line reply cmds."};
static char	*connecthelp[] =	{"<host>",
					"connect to remote Post Office Protocol server <host>"};
static char	*debughelp[] = { "[<val>]", "toggle/set: debugging mode"};
static char	*deletehelp[] =	{"<n> ...", "delete message[s] <n> ..."};
static char *deliverhelp[] = {"[-Dcmd <cmd>] [-t <name>]",
				"deliver messages received during POP session [to <name>]\n"
				"\t [using <cmd> instead of " _PATH_DELIVER "]"};
static char	*disconhelp[] =	{"", "terminate pop session"};
static char	*getallhelp[] =	{"[\"nodelete\"]",
				  "retrieve and mark for deletion? all messages"};
static char	*helphelp[] =	{"[<cmd> ...]", "print local help information"};
static char	*hosthelp[] =	{"<host>",
					 "specify host for maildrop access (not in any rfc!)"};
static char	*lasthelp[] = {"",
			"give highest message number accessed (not in rfc1725)"};
static char	*listhelp[] = {"[<n> ...]",
						 "list size of all messages or message[s] <n> ..."};
static char	*printlisthelp[] = {"", "list all received messages"};
static char *queuehelp[] = {"[-Dcmd <cmd>] [-t <name>]",
				"deliver messages from receive queue [to <name>]\n"
				"\t [using <cmd> instead of " _PATH_DELIVER "]"};
static char	*quithelp[] = {"", 
					"terminate pop session, Auto-deliver? mails and exit"};
static char	*resethelp[] =	{"", "unmark messages marked for deletion"};
static char	*retrievehelp[] = {"<n> ...", "retrieve message[s] <n> ..."};
static char	*showstatushelp[] =	{"", "print pop3-client-status"};
static char	*statushelp[] =	{"", "give message count and size of maildrop"};
static char	*tophelp[] = { "<m> [<n>]",
						"print header and <n> lines of a message <m>"};
static char	*uidlhelp[] = {"[<n> ...]",
				 "print \"unique-id listing\" for all or message[s] <n> ..."};
static char	*userhelp[] = {"<user> [<passwd>]",
						"specify user & password for maildrop access"};
static char	*verbosehelp[] = {"[on]", "toggle/set: verbose mode"};

struct cmd cmdtab[] = {
	{ "apop",	apophelp,			0,	1,	1,	apop },
	{ "autodeliver", autodeliverhelp,	0,	0,	2,	setautodeliver },
	{ "bell",	beephelp,			0,	0,	2,	setbell },
	{ "bye",	quithelp,			0,	0,	2,	(int(*)())quit },
	{ "close",	disconhelp,			0,	1,  2,	disconnect },
	{ "debug",	debughelp,			0,	0,	2,	setdebug },
	{ "delete",	deletehelp,			2,	2,	2,	delete },
	{ "deliver", deliverhelp,		1,	0,	2,	deliver },
	{ "disconnect",	disconhelp,		0,	1,	2,	disconnect },
	{ "dropmails",	getallhelp,		1,	2,	2,	getall },
#define DROPIDX 9
	{ "get",	retrievehelp,		1,	2,	2,	retrieve },
#define GETIDX 9
	{ "help",	helphelp,			2,	0,	2,	help },
	{ "host",	hosthelp,			0,	2,	2,	sethost },
	{ "last",	lasthelp,			0,	2,	2,	last },
	{ "list",	listhelp,			2,	2,	2,	list },
	{ "open",	connecthelp,		0,	0,	0,	setpeer },
	{ "printlist",	printlisthelp,	1,	0,	2,	(int (*)())printlist },
	{ "queuedeliver", queuehelp,	1,	0,	2,	deliver },
	{ "quit",	quithelp,			0,	0,	2,	(int (*)())quit },
	{ "reset",	resethelp,			0,	2,	2,	reset },
	{ "retrieve",	retrievehelp,		1,	2,	2,	retrieve },
#define RETRIDX 19
	{ "show",	showstatushelp,		0,	0,	2,	showstatus },
	{ "status",	statushelp,			0,	2,	2,	getstatus },
	{ "top",	tophelp,			1,	2,	2,	top },
	{ "uidl",	uidlhelp,			1,	2,	2,	uidl },
	{ "user",	userhelp,			0,	1,	1,	usrpass },
	{ "verbose",	verbosehelp,	0,	0,	2,	setverbose },
	{ "?",		helphelp,			0,	0,	2,	help },
	{ 0 },
};

int	NCMDS = (sizeof (cmdtab) / sizeof (cmdtab[0])) - 1;



/* 
 * lock_retrive
 * 
 * 
 */

int	lock_retrieve( int mode)
{
	int	state;

	if(mode)
		state = ISLOCKED;
	else
		state = TRANSACT;

	if(cmdtab[DROPIDX].c_conn <= ISLOCKED)
		cmdtab[DROPIDX].c_conn = state;
	if(cmdtab[GETIDX].c_conn <= ISLOCKED)
		cmdtab[GETIDX].c_conn = state;
	if(cmdtab[RETRIDX].c_conn <= ISLOCKED)
		cmdtab[RETRIDX].c_conn = state;

	return(TRUE);
}	/* lock_retrive	*/


