/*
 * Copyright (c) 1994/95 jerry g geiger
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms.
 * This program my not be sold in any way!
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * This program's code is based on ftp-client code 
 * ftp Copyright (c) 1985, 1989 Regents of the University of California.
 *
 *
 * pop3 according rfc 1225
 */

#ifdef SCCS
static char sccsid[] = "@(#)cmds.c, pop3 (j.g.geiger) 95/12/8";
#endif /* not lint */

/*
 * pop3 User Program -- pop3 Command Routines.
 */

#define _cmdsPOP3

#include "pop3.h"
#include <pwd.h>

extern int	abrtflag;



/*
 * Connect to peer server and
 * auto-login, if possible.
 */
setpeer(argc, argv)
	int argc;
	char *argv[];
{
	char *host, *hookup();
	short port;

	if (connected) {
		printf("Already connected to %s, use close first.\n",
			hostname);
		code = -1;
		return(-1);
	}
	if (argc < 2) {
		(void) strcat(line, " ");
		printf("(to) ");
		(void) gets(&line[strlen(line)]);
		makeargv();
		argc = margc;
		argv = margv;
	}
	if (argc > 3) {
		printf("usage: %s host-name [port]\n", argv[0]);
		code = -1;
		return(-1);
	}
	port = sp->s_port;
	if (argc > 2) {
		port = atoi(argv[2]);
		if (port <= 0) {
			printf("%s: bad port number-- %s\n", argv[1], argv[2]);
			printf ("usage: %s host-name [port]\n", argv[0]);
			code = -1;
			return(-1);
		}
		port = htons(port);
	}
	host = hookup(argv[1], port);
	if (host) {
		int overbose;

		connected = 1;
		if (autologin)
			(void) login(argv[1]);
	}
	return(0);
}



char *
onoff(bool)
	int bool;
{

	return (bool ? "on" : "off");
}

/*
 * Show status.
 */
/*ARGSUSED*/
showstatus(int argc, char *argv[])
{
	char *p; int i;
	printf("pop3: '%s', vers: %s",myname, Version);
	if(debug)
		printf(" (pid:%d, uid:%d, euid:%d egid%d)\n", getpid(), getuid(),
					geteuid(), getegid());
	else
		printf("\n");
	if (connected) {
		printf("Connected to %s.\nConnection in ", hostname);
		if(connected == AUTHORI)
			printf("AUTHORIZATION state. Not yet logged in.\n");
		else {
			printf("TRANSACTION state. ");
			if(command(0, "NOOP") && code == PSI)
				printf("Tested and confirmed.\n");
			else
				printf("Error: %s\n", code == NSI ? reply_tok :"No reply!");
		}
	} else
		printf("Not connected.\n");
		

	if(getmails4host)
		printf("PostOfficeBox: '%s' Handle messages for %s.\n", 
			the_host, "that host");
	else {
		printf("PostOfficeBox: '%s' Handle messages for %s.\n", 
			 r_user ? r_user : "<user>", 
			 connected > 1 ? "logged in user" : "user to login");
		printf("Delivery to '%s'.\n", the_user);
	}
	p = "";
	if(interactive == 2)
		p = "interactive";
	else if(interactive == 1)
		p = "stdin-cmd-script";
	else
		p = "retrieve mails"; 
	printf("Mode: %s\n", p);
	printf("    Verbose: %s; Bell: %s; Debug: %s; Auto-deliver: %s\n", 
		onoff(verbose), onoff(bell), onoff(debug), onoff(autodeliver));


	return(code = 0);
}

/*
 * Set beep on cmd completed mode.
 */
/*VARARGS*/
setbell(int argc, char *argv[])
{
	if (argc > 1)
		bell = TRUE;
	else
		bell = !bell;
	if(verbose || argc > 1)
		printf("Bell mode %s.\n", onoff(bell));
	
	return(code = 0);
}


/*
 * Turn on printing of server echo's.
 */
/*VARARGS*/
setverbose(int argc, char *argv[])
{
	if(argc > 1)
		verbose = 1;
	else
		verbose = !verbose;
	if(verbose || argc > 1)
		printf("Verbose mode %s.\n", onoff(verbose));
	return(code = 0);
}

/*
 * Turn on printing of server echo's.
 */
/*VARARGS*/
setautodeliver(int argc, char *argv[])
{
	if(argc > 1)
		autodeliver = TRUE;
	else
		autodeliver = !autodeliver;
	if(verbose || argc > 1)
		printf("Auto-deliver mode %s.\n", onoff(autodeliver));

	return(code = 0);
}


/*
 * Set debugging mode on/off and/or
 * set level of debugging.
 */
/*VARARGS*/
setdebug(int argc, char *argv[])
{
	int val;

	if (argc > 1) {
		val = atoi(argv[1]);
		if (val < 0) {
			printf("%s: bad debugging value.\n", argv[1]);
			code = -1;
			return(-1);
		}
	} else
		val = !debug;
	debug = val;
	if (debug)
		options |= SO_DEBUG;
	else
		options &= ~SO_DEBUG;
	if(verbose || argc > 1)
		printf("Debugging %s (debug=%d).\n", onoff(debug), debug);

	return(code = 0);
}



/*
 * login (USER,PASS), Send user information
 */
usrpass(argc, argv)
	int argc;
	char **argv;
{
	char *getpass();
	int n, aflag = 0;

	if ((argc < 2) && interactive ) {
		(void) strcat(line, " ");
		printf("(username) ");
		(void) gets(&line[strlen(line)]);
		makeargv();
		argc = margc;
		argv = margv;
	}
	if ( (argc > 3) || (argc < 2) ){
		printf("usage: %s username [password]\n", argv[0]);
		code = -1;
		return (0);
	}
	n = command(0, "USER %s", argv[1]);
	if (n && code == PSI) {
		if (argc < 3 )
			argv[2] = getpass("Password: "), argc++;
		n = command(0, "PASS %s", argv[2]);
	}
	if(r_user = malloc(strlen(argv[1])+1))
		strcpy(r_user,argv[1]);
	if (code != PSI) {
		fprintf(stdout, "Login failed.\n");
		return (0);
	}
	connected = TRANSACT;
	return (1);
}

/*
 * login (APOP) Send user authentification
 */
apop(argc, argv)
	int argc;
	char **argv;
{
	int n, aflag = 0; char *p;
	char *getpass();

	if(!apop_id) {
		if(verbose)
			printf("APOP not supported by server @%s\n", hostname);
		else {
			fprintf(stderr, "%s(%d): ", myname, getpid());
			fprintf(stderr, "APOP not supported by server @%s\n", hostname);
		}
		return(-1);
	}
	if ((argc < 3) && interactive ) {
		if(argc < 2) {
			(void) strcat(line, " ");
			printf("(username) ");
			(void) gets(&line[strlen(line)]);
			makeargv();
			argc = margc;
			argv = margv;
		}
		if (argc < 3 )
			argv[2] = getpass("secret: "), argc++;
	}
	if (argc != 3 ){
		printf("usage: %s name secret\n", argv[0]);
		code = -1;
		return (0);
	}
	code = 0;
	if(p = malloc(strlen(apop_id)+strlen(argv[2])+1)) {
		strcpy(p, apop_id);
		strcat(p, argv[2]);
		n = command(0, "APOP %s %s", argv[1], MD5digest(p, NULL));
		bzero(p, strlen(p));
		bzero(argv[2], strlen(argv[2]));
		free(p);
		if(r_user = malloc(strlen(argv[1])+1))
			strcpy(r_user,argv[1]);
	}
	if (code != PSI) {
		fprintf(stdout, "APOP login failed.\n");
		return (0);
	}
	connected = TRANSACT;

	return (1);
}


/*
 * STAT: mailbox status on PO Server (get drop listing)
 * 
 */
getstatus(int argc, char *argv[])
{

	if (argc > 1) {
		printf("usage:%s\n", argv[0]);
		code = -1;
		return(0);
	}
	if (!command(2, "STAT")){
		if (verbose && (code == NSI))
			printf("STAT command not recognized.\n");
	}
	return(0);
}



/*
 * get "scan listings": LIST [m]
 */
list(int argc, char *argv[])
{
	int i;
	if (argc > 1 ) {
		for (i = 1; i < argc; i++)
			command(2, "LIST %s", argv[i]);
		return(0);
	}  /* else if (argc < 2) */
		
	command(1, "LIST");
	if(code == PSI)
		multiline();
	return(0);
}


/*
 * get "unique id listing": UIDL [m]
 */
uidl(int argc, char *argv[])
{
	int i;
	if (argc > 1 ) {
		for (i = 1; i < argc; i++)
			command(2, "UIDL %s", argv[i]);
		return(0);
	}  /* else if (argc < 2) */
		
	command(1, "UIDL");
	if(code == PSI)
		multiline();
	return(0);
}

/*
 * Retrive messages. RETR <m>
 */
retrieve (int argc, char *argv[])
{
	int i, ii;

	if ((argc < 2) && interactive )  {
		(void) strcat(line, " ");
		printf("(message id?) ");
		(void) gets(&line[strlen(line)]);
		makeargv();
		argc = margc;
		argv = margv;
	}
	if (argc < 2) {
		printf("usage: %s <msg_id> ...\n", argv[0]);
		code = -1;
		return (0);
	}
	ii = 0;
	for (i = 1; i < argc; i++) {
		if (do_retrieve(argv[i]))
			ii++;
		if(abrtflag)
			break;
	}
	if(verbose && ((argc > 2) || !ii) )
		printf("%d of %d messages received %s\n", ii, argc-1, 
					abrtflag ? "(aborted)":"");

	return (0);
}

/*
 * Delete messages: DELE <m>
 */
delete(int argc, char *argv[])
{
	int i, ii;

	if ((argc < 2) && interactive ) {
		(void) strcat(line, " ");
		printf("(message id?) ");
		(void) gets(&line[strlen(line)]);
		makeargv();
		argc = margc;
		argv = margv;
	}
	if (argc < 2) {
		printf("usage: %s <msg_id> ...\n", argv[0]);
		code = -1;
		return(-1);
	}
	ii = 0;
	for (i = 1; i < argc; i++) {
		command(0, "DELE %s", argv[i]);
		if (code == PSI)
			ii++;
		if(abrtflag)
			break;
	}
	if(verbose && ii)
		printf("%d of %d messages marked for deleting %s\n", ii, argc-1,
						abrtflag ? "(aborted)":"");
	return(0);
}



/*
 * get number of highest message accessed: LAST
 */
last(int argc, char *argv[])
{
	command(1, "LAST");
	return(0);
}

/*
 * unmark deleted messages and reset 'LAST' msg: RSET
 */
reset(int argc, char *argv[])
{
	command(0, "RSET");
	return(0);
}


/*
 * TOP:
 */
top(int argc, char *argv[])
{

	if ((argc < 2) && interactive ) {
		(void) strcat(line, " ");
		printf("(message-id?) ");
		(void) gets(&line[strlen(line)]);
		makeargv();
		argc = margc;
		argv = margv;
	}
	if (argc < 2) {
		printf("usage: %s <msg_id> [lines]\n", argv[0]);
		code = -1;
		return(-1);
	}
	if (command(0, argc > 2 ? "TOP %s %s" : "TOP %s 2" , argv[1], argv[2]) && code == PSI)
		multiline();
	else {
		if(verbose)
			printf("TOP command not recognized, or msg not found\n");
	}

}

static char usedhostname[MAXDOMAINNAMELEN+1];
	/* needed for show 	*/
/*
 * HOST:
 */
sethost(int argc, char *argv[])
{

	if ((argc < 2) && interactive ) {
		(void) strcat(line, " ");
		printf("(host-name?) ");
		(void) gets(&line[strlen(line)]);
		makeargv();
		argc = margc;
		argv = margv;
	}
	if (argc < 2) {
		printf("usage: %s <hostname>\n", argv[0]);
		code = -1;
		return(-1);
	}
	if(command(0, "HOST %s", argv[1])){
		make_id_prefix();
		getmails4host = TRUE;
		strcpy(usedhostname, argv[1]);
		the_host = usedhostname;
		return(TRUE);
	}
	lock_retrieve(TRUE);

	return(FALSE);
}


/*
 * Terminate session, but don't exit: QUIT
 */
disconnect()
{
	extern FILE *cout;
	extern int data;

	lock_retrieve(FALSE);
	if (!connected)
		return(-1);
	(void) command(0, "QUIT");
	if (cout) {
		(void) fclose(cout);
	}
	cout = NULL;
	connected = 0;
	make_id_prefix(); /* new for new session */
	logmessage(LOGDISSCON);
	return(0);
}


getall(int argc, char *argv[])
{	
	int delmails = TRUE;
	if(argc > 1) {
		if(!strcmp(argv[1], "nodelete")) {
			argc--;
			delmails = FALSE;
		}
	}
	if (argc > 1) {
		printf("usage: %s [nodelete]\n", argv[0]);
		code = -1;
		return(-1);
	}
	return(get_mails(delmails));
}

deliver(int argc, char *argv[])
{
	char *deliver_to = NULL, *deliver_box = NULL, *deliver_cmd = NULL;
	int deliver_uid = 0, i; struct passwd *pwent;
	
	if(!argc & 1) {
		if(verbose)
			printf("usage: %s [-Dcmd <cmd>] [-t <name>]", argv[0]);
		else
			myerror("bad arguments for deliver cmd",0);
		return(-1);
	}
	for(i = 1; i+1 <= argc ; i++ ) {
		if( !strcmp(argv[i],"-Dcmd") )
			deliver_cmd = argv[++i];
		else if( !strcmp(argv[i],"-Dbox") )
			deliver_box = argv[++i];
		else if( !strcmp(argv[i],"-t") )
			deliver_to =  argv[++i];
		else {
			if(verbose)
				printf("usage: %s [-Dcmd <cmd>] [-t <name>]\n", argv[0]);
			else
				myerror("bad arguments for deliver cmd",0);
			return(-1);
		}
				
	}
	if(deliver_to) {
		if(pwent = getpwnam(deliver_to))
			deliver_uid = pwent->pw_uid;
		else {
			deliver_uid = geteuid();
			myerror("no passwd entry for recipient!",0);
		}
	}
		
	if(!strncmp(argv[0], "deliver", strlen(argv[0])))
		do_deliver( deliver_to ? deliver_to : the_user, 
					deliver_to ? deliver_uid : getuid(),
					deliver_box ? deliver_box : NULL,
					deliver_cmd ? deliver_cmd :  _PATH_DELIVER);

	else 		/* if(!strcmp(argv[0], "processqueue")) */
		do_deliverqueue( deliver_to ? deliver_to : the_user, 
					deliver_to ? deliver_uid : getuid(),
					deliver_box ? deliver_box : NULL,
					deliver_cmd ? deliver_cmd :  _PATH_DELIVER);

	return(0);

}



int printlist(int argc, char *argv[])
{
	return(do_printlist());
}
/*
 * Terminate session and exit.
 */
/*VARARGS*/
void quit()
{

	if (connected)
		disconnect();
	if(autodeliver && recmsgs)
		do_deliver(the_user, getuid(), NULL, _PATH_DELIVER);

	savelist();
	
	exit(0);
}


/* eof	*/
