/* MD5 interface function MD5File()
 * implemented according rfc1321 and example in mddriver.c:
 *  (Copyright (C) 1990-2, RSA Data Security, Inc. Created 1990. All
 *   rights reserved.)
 * (C) jerry g geiger 1995
 */

#include <stdio.h>
#include <string.h>
#include "global.h"
#include "md5.h"


/* Digests a file and return the result.
 * <result> maybe NULL, an internal buffer is used then.
 */
static unsigned char mydigest[16];

unsigned char *MD5File (FILE *file, unsigned char* result)
{
	MD5_CTX context;
	int len;
	unsigned char *digest;
	unsigned char buffer[1024];
	
	if(!file)
		return(NULL);
	if(!(digest = result))
		digest = mydigest;
	
	MD5Init (&context);
	while ( (len = fread (buffer, 1, 1024, file)) > 0 )
		MD5Update (&context, buffer, len);
		
	MD5Final (digest, &context);

	return(digest);
}
