/*	mark saeger,	msaeger@cse.unl.edu				*/
/*	termcap.c							*/
/*	Copyright 1995 Mark Saeger.					*/
/*									*/
/*	Permission is granted to any individual or instituition to use,	*/
/*	copy, or redistribute this executable so long as it is not	*/
/*	modified and that it is not sold for profit.			*/
/*									*/
/*	LIKE ANYTHING THAT IS FREE, MORE IS PROVIDED AS IS AND COMES	*/
/*	WITH NO	WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED.	*/
/*	IN NO EVENT WILL THE COPYRIGHT HOLDER BE LIABLE FOR ANY DAMAGES	*/
/*	RESULTING FROM THE USE OF THIS SOFTWARE.			*/

/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/*must use TIOCGWINSZ to get the width/height*/
/*must also initialize termional w/ ti*/
/**************************************/

#include "more.h"

#ifdef MINT
#include <termcap.h>
#endif

#ifdef UNIX
#include <curses.h>
#include <term.h>
#endif  /*have this after for redef of TRUE/FALSE*/

/*********/
char *clearbuf, *bold, *norm, *bright, *nobright, *under, *nounder, *under1,
	*reset, *cleod, *cleol, *cls, *cr, *ll, *curson, *cursoff, *homec;
int mcolumns, mlines;	/*returned by tgetnum(columns/lines)*/
int automarg;
/********/

int putch(int ch)
{
	putchar(ch);
}

void setup_termcap(void)
{
	extern int optml, optu;
	extern int mcolumns, mlines;

	char *termtype;
	static char buffer[1024];	/*storage area for tgetent*/
	static char buf2[256];		/*scratch area for tgetstr*/
			/*if not big enough will get core dump if make too
			many calls*/

	extern char	*clearbuf, *bold, *norm, *bright, *nobright,
			*under, *nounder, *under1, *reset, *cleod, *cleol,
			*cls, *cr, *ll, *curson, *cursoff, *homec;
	extern int	automarg;

/*also vi,ve,am,ho[line1194 && 2777] in termcap.doc*/

	termtype = getenv("TERM");
/*MUST TEST FOR NULL*/
	tgetent(buffer,termtype);
	mcolumns = tgetnum("co");
	mlines = tgetnum("li");
	automarg = tgetflag("am");
#ifdef MINT
	if(mlines==24)	/*termcap is wrong*/
		mlines=mlines+1;	/*only returns 24 vs the actual 25*/
#endif
	if(optml)
		mlines = optml;	/*maybe disallow if optml > mlines?*/
	clearbuf=buf2;	/*must pass a scratch area, I chose 24 bytes*/
	reset=tgetstr("rc",&clearbuf);  /*clears screen for next screenful*/
	bold = tgetstr("so",&clearbuf);		/*use for reverse --MORE--*/
	norm = tgetstr("se",&clearbuf);
	bright = tgetstr("md",&clearbuf);  /*use for bold in text*/
	nobright= tgetstr("me",&clearbuf);
	if(bright==NULL)
	{
		bright=bold;
		nobright=norm;
	}
	under = tgetstr("us",&clearbuf);
	nounder = tgetstr("ue",&clearbuf);
	if(under==NULL || optu)	/*if no underline, 1st standout, then reverse*/
	{
		if(bright == bold)
		{
			under=bold;
			nounder=norm;
		}
		else
		{
			under=bright;
			nounder=nobright;
		}
	}
	under1 = tgetstr("uc", &clearbuf);
	if((cleod= tgetstr("cd",&clearbuf))==NULL)
		printf("terminal can't clear to end of display\n");
	if((cleol= tgetstr("ce",&clearbuf))==NULL)
		printf("terminal can't clear to end of line\n");
	cls  = tgetstr("cl",&clearbuf);
	homec= tgetstr("ho",&clearbuf);
	if(homec!=NULL)
		cls=homec;
	if((cr = tgetstr("cr",&clearbuf))==NULL)
/*		printf("terminal has no carriage return defined\n");*/
	if((ll   = tgetstr("ll",&clearbuf))==NULL)
/*		printf("terminal can't ll\n");*/
	curson = tgetstr("ve",&clearbuf);
	cursoff = tgetstr("vi",&clearbuf);
}
