/* @(#)ssystem.c mint/freemint
 * $Id$
 * by jerry g geiger
 *  - jerry@zedat.fu-berlin.de  or jerry@merlin.abacus.de
 * almost completely rewritten by Draco, draco@mi.com.pl, Warszawa, 4.XII.1997. 
 * 
 * 

 General purpose: access vital system variables and constants without need
 to switch to Supervisor mode. Prototype:

 long ARGS_ON_STACK s_system(int mode, ulong arg1, ulong arg2)

 */

#include "version.h"
#include "cookie.h"
#include "mint.h"
#include "ssystem.h"
#include "build.h"
#include "ioctl.h"

extern int vm_in_use; /* from main.c */
extern int no_mem_prot;
extern int secure_mode;
extern int time_slice; /* from proc.c */

short run_level = 1;		/* default runlevel */
short disallow_single = 0;

/* definitions in version.h */
static long MiNT_version = (ulong)MAJ_VERSION<<24|(ulong)MIN_VERSION<<16|(ulong)PAT_LEVEL<<8|(ulong)BETA_IDENT;

/* definitions in automatically created buildtime.h */
static long MiNT_date = (ulong)BUILD_DAY<<24|(ulong)BUILD_MONTH<<16|(ulong)BUILD_YEAR;
static long MiNT_time = (ulong)BUILD_DAY_OF_WEEK<<24|(ulong)BUILD_HOUR<<16|(ulong)BUILD_MIN<<8|(ulong)BUILD_SEC;

/* jerry:
 * find cookie cookiep->tag and return it's value in 
 * cookiep->value, return 0
 * return -1 if not found
 */

static long get_cookie(ulong arg1)
{
	COOKIE *cjar;
	int slotnum = 0;  /* number of already taken slots */

	cjar = *CJAR;     /* for compatibility. */

	/* If arg1 == 0, we return the value of NULL slot */

	if (arg1 == 0) {
		while(cjar->tag)
			cjar++;
		return(cjar->value);
	}

	/* if the high word of arg1 is zero, this is the slot number
	   to look at. The first slot is number 1. */

	if ((arg1 & 0xffff0000) == 0) {
		while(cjar->tag) {
			cjar++;
			slotnum++;
		}
		slotnum++;
		if (arg1 > slotnum)
			return(-1);
		cjar = *CJAR;
		slotnum = 1;
		while(slotnum != arg1) {
			slotnum++;
			cjar++;
		}
		return(cjar->tag);
	}	

	/* all other values of arg1 mean tag id to search for */
	
	while(cjar->tag) {
		if(cjar->tag == arg1)
			return(cjar->value);
		cjar++;
	}
	return(-1);
}


/* 
 * add cookie cookiep->tag to cookie list or change it's value
 * if already existing
 * 
 */

static long set_cookie(ulong arg1, ulong arg2)
{
	COOKIE * cjar; int n = 0;
	cjar = *CJAR;	/* for compatibility. 	*/

	/* 0x0000xxxx feature of GETCOOKIE may be confusing, so
	   prevent users from using slotnumber HERE :) */

	if ((arg1>>24 == 0)||((arg1&0x00ff0000) == 0)||((arg1&0x0000ff00) == 0)||((arg1&0x000000ff) == 0))
		return(-1);	/* Bad tag id */

	while(cjar->tag) {
		n++;
		if(cjar->tag == arg1) {
			cjar->value = arg2;
			return(0);
		}
		cjar++;
	}
	n++;
	if(n <  cjar->value) {
		n =  cjar->value;
		cjar->tag = arg1;
		cjar->value = arg2;
		cjar++;
		cjar->tag = 0L;
		cjar->value = n;
		return(0);
	}
	return(ENSMEM);	/* LIST exhausted :-)	*/
}

long ARGS_ON_STACK s_system(short mode, ulong arg1, ulong arg2)
{
	int isroot = 0;		/* check euid -> 1, ruid --> 2	*/
	unsigned long *lpointer;
	unsigned int  *wpointer;
	unsigned char *bpointer;
	unsigned long *sysbase;
	short *mfp;

	if(curproc->euid == 0)
		isroot = 1;
	if(curproc->ruid == 0)
		isroot = 2;

	if(mode == -1)	/* yes this call exists	*/
		return(0L);
	
	switch(mode) 
	{
	/* Kernel information */
		case OSNAME:
			return (0x4d694e54L) /* 'MiNT' */ ;break;
		case OSXNAME:
			return VERS_IDENT; break;
		case OSVERSION:
			return MiNT_version; break;
		case TOSHEADER:
			sysbase = *((long **)(0x4f2L));
			arg1 = arg1 & 0x00000ffe;	/* 4k allowed */
			return sysbase[arg1];
			break;
		case OS_BUILD_DATE:
			return MiNT_date; ;break;
		case OS_BUILD_TIME:
			return MiNT_time; ;break;
		case COMPILE_TYPE:
#ifdef CPU060
			return (0x0000003cL);	/* 060 kernel */
#endif
#ifdef CPU040
			return (0x00000028L);	/* 040 kernel */
#endif
#ifdef ONLY030
			return (0x0000001eL);	/* 030 kernel */
#endif
			break;			/* generic 68000 */
		case FEATURES:
			return (((!no_mem_prot)&0x01)|((vm_in_use<<1)&0x02)|(secure_mode<<2));
			break;
	/* GEMDOS variables */
		case GET_LVAL:
			arg1 = arg1 & 0xfffffffe;
			lpointer = (unsigned long *)arg1;
			if (arg1<0x08 || arg1>0xfffc)
				return (0L);
			return (*lpointer);
			break;
		case GET_WVAL:
			arg1 = arg1 & 0xfffffffe;
			wpointer = (unsigned int *)arg1;
			if (arg1<0x08 || arg1>0xfffe)
				return (0L);
			return (*wpointer);
			break;
		case GET_BVAL:
			bpointer = (unsigned char *)arg1;
			if (arg1<0x08 || arg1>0xffff)
				return (0L);
			return (*bpointer);
			break;
		case SET_LVAL:
			if (isroot == 0)
				return EACCDN;
			arg1 = arg1 & 0xfffffffe;
			lpointer = (unsigned long*)arg1;
			if (arg1<0x08 || arg1>0xfffc)
				return EACCDN;
			*lpointer = arg2;
			break;
		case SET_WVAL:
			if (isroot == 0)
				return EACCDN;
			arg1 = arg1 & 0xfffffffe;
			wpointer = (unsigned int*)arg1;
			if (arg1<0x08 || arg1>0xfffe)
				return EACCDN;
			*wpointer = arg2;
			break;
		case SET_BVAL:
			if (isroot == 0)
				return EACCDN;
			bpointer = (unsigned char*)arg1;
			if (arg1<0x08 || arg1>0xffff)
				return EACCDN;
			*bpointer = arg2;
			break;
	/* Cookie Jar functions */
		case GETCOOKIE:
			return get_cookie(arg1);
			break;
		case SETCOOKIE:
			if (isroot == 0)
				return EACCDN;
			return set_cookie(arg1, arg2);
			break;
	/* Hack (dirty one) for MiNTLibs */
		case TIOCMGET:
			mfp = (short *)arg1;
			return ((*mfp)&0x00ff);
			break;
		case SYS_SLEVEL:
			if (isroot == 0)
				return EACCDN;
			if (arg1 == -1)
				return (long)secure_mode;
			if (arg1 < 0 || arg1 > 2) return EACCDN;
			secure_mode = (short)arg1;
			break;
		case RUN_LEVEL:
			if (isroot == 0 || disallow_single)
				return EACCDN;
			if (arg1 == -1)
				return run_level;
			if (arg1 == 0 || arg1 == 1)
				run_level = (short)arg1;
			else
				return EACCDN;
			break;
		case TSLICE:
			if (isroot == 0)
				return EACCDN;
			if (arg1 == -1)
				return (long)time_slice;
			time_slice = (short)arg1;
			break;				
		default:
			return EINVFN;	/* invalid function number */
			break;						
	}
	return(0L);
}

/* eof ssystem.c	*/
