
*	IDLE
*
* An alternative to 'NIGHT', that leaves the VBLanks coming...
* Conforms to my "resident utility protocol".
* By Moshe Braner, 871211.

* This version is for the GST Assembler.

DELAY   equ     36000           3 minutes * 200 Hz

IDLE    equ    $49444C45        "IDLE"

GEMDOS  equ       1             GEMDOS trap number
XBIOS   equ      14             XBIOS trap number

TERM    equ       0             GEMDOS: terminate process
PRTS    equ       9             GEMDOS: print string
TERMRES equ     $31             GEMDOS: terminate and keep process resident
SUPEXEC equ      38             XBIOS:  supervisor execution

TAB     equ       9
LF      equ      10             line feed
CR      equ      13             cursor return

* system variables that will be affected

BIOSVEC equ    $0B4             BIOS trap vector
TIMVEC  equ    $114             system timer vector
KBDVEC  equ    $118             keyboard IRQ

* video locations:

PHYS    equ     $FFFF8200       video ram pointer
PHYSHI  equ     $FFFF8201       video ram pointer high byte
PHYSLO  equ     $FFFF8203       video ram pointer low  byte
COLOR0  equ     $FFFF8240       palette register 0

* start of code

        SECTION IDLE

        bra     start           call non-resident init routine

* start of RAM-resident routine

* timer trap - called every 5 msec
*
* check if timer expired. If so, shift video pointer
* exit: old timer trap vector

        dc.l    IDLE
timold  ds.l    1               original system timer vector

timtrp  movem.l a0/d0,-(sp)     save work registers
        tst.w   flag            is it day or night ?
        bne.s   norm            night, leave me alone
        lea     timer,a0
        subq.l  #1,(a0)         decrement count
        bpl.s   norm            not time yet: continue normally
        move.w  #1,flag
        lea     COLOR0,a0
        move.w  (a0),oldpal     save original color
        tst.w   zflag           is the alt screen all zeros?
        beq.s   all0
        not.w   (a0)            reverse colors instead
        bra.s   norm
all0    clr.w   (a0)            poke black
        lea     PHYS,a0
        move.b  1(a0),d0
        lsl.w   #8,d0
        move.b  3(a0),d0
        move.w  d0,oldp         save original video pointer
        move.w  altp,d0
        move.b  d0,3(a0)        poke alternative pointer
        lsr.w   #8,d0
        move.b  d0,1(a0)
norm    lea     index,a0
        move.w  (a0),d0
        bpl.s   conti
        clr.w   zflag           all zeros now, OK to shift video
        move.w  #32000,d0       scan 32000 bytes (8 per interrupt)
conti   subq.w  #8,d0
        move.w  d0,(a0)         save new index
        move.l  altpp,a0
        tst.l   (a0,d0.w)       check 4 bytes in alternative screen
        bne.s   ohno            oh, no!
        tst.l   4(a0,d0.w)      check another 4 bytes
        beq.s   retrt           they are 0, OK
ohno    bsr.s   manip           too bad - stay awake
        move.w  #32000,index    start scanning from the top again
        move.w  #1,zflag
retrt   movem.l (sp)+,a0/d0     restore registers ...
        move.l  timold,-(sp)    ... and exit via original timer vector
        rts

* BIOS trap - called on every BIOS call
*
* check if Bconout() is specified. If so, reset timer.
* Reset screen to normal if flag was 1.
* Exit to original BIOS trap handler.

        dc.l    IDLE
biosold ds.l    1               original BIOS trap vector
biostrp move.l  d0,-(sp)        save D0
        move.w  10(sp),d0       D0 := specified BIOS function code
        cmp.w   #3,d0           is it Bconout() ?
        bne.s   noout           no:  continue normally
        bsr.s   manip           yes: perform operation ...
noout   move.l  (sp)+,d0        ... restore D0 ...
        move.l  biosold,-(sp)   ... and exit via original BIOS trap vector
        rts

* keyboard trap - called on every mouse or keyboard interrupt

        dc.l    IDLE
kbdold  ds.l    1               original keyboard interrupt vector
kbdtrp  bsr.s   manip
        move.l  kbdold,-(sp)    exit via original keyboard vector
        rts

* common code for waking up or staying awake
*
* reset timer. If flag = 1, set screen mode back to normal.

manip   tst.w   flag            is it day or night ?
        beq.s   retrm           still day: do nothing
        move.w  oldp,d0
        move.b  d0,PHYSLO       poke original pointer
        lsr.w   #8,d0
        move.b  d0,PHYSHI
        move.w  oldpal,COLOR0   poke original color
        clr.w   flag            it's daytime now
retrm   move.l  #DELAY,timer    start timing
        rts

* storage for flags and pointers

flag    dc.w    0           night/day flag (0 = day)
timer   dc.l  DELAY         timer count (ticks every 5 msec)
index   dc.w    0           zero check counter
zflag   dc.w    0           alt screen is clear flag (0 = clear)
oldp    ds.w    1           original video pointer
oldpal  ds.w    1           original palette register 0
altp    ds.w    1           alternative video pointer
altpp   ds.l    1           altp in full glory

* end of RAM-resident routine, start of initialization routine
* (all this will be killed after init)

* set new vectors in supervisor mode

start   pea     ivec
        move.w  #SUPEXEC,-(sp)
        trap    #XBIOS
        addq.l  #6,sp

* display signon msg

        pea     msg
        move.w  #PRTS,-(sp)
        trap    #GEMDOS
        addq.l  #6,sp

* wait loop

wloop   moveq   #10,d1          D1 := outer loop counter
loop2   moveq   #-1,d0          D0 := inner loop counter
loop1   dbra    d0,loop1        execute inner ...
        dbra    d1,loop2        ... and outer loop

* terminate but stay resident

        lea     start,a0        a0 := end of resident part, minus
        sub.l   4(sp),a0        base page address = length to keep
        clr.w   -(sp)
        move.l  a0,-(sp)
        move.w  #TERMRES,-(sp)
        trap    #GEMDOS

* find the alternative video location: 32K below current

ivec    clr.l   d0
        lea     PHYS,a0
        move.b  1(a0),d0
        asl.w   #8,d0
        move.b  3(a0),d0
        sub.w   #128,d0         slide down 32K in 256-byte chunks
        move.w  d0,altp         this is it
        asl.l   #8,d0
        move.l  d0,altpp        the actual address

* set system vectors: save original ones, replace them by new ones

        move.l  KBDVEC,a0
        cmp.l   #IDLE,-8(a0)    if "IDLE" is there
        beq.s   done            then don't do it over
        moveq   #2,d0           we've got 3 vectors to process
        sub.l   d1,d1           clear D1 (index registers)
        lea     oldtab,a0       A0 ==> table for original vectors
inxt    move.l  00(a0,d1.l),a1  A1 ==> vector address
        move.l  12(a0,d1.l),a2  A2 ==> storage area for old value
        move.l  24(a0,d1.l),a3  A3 ==> new value
        move.l  (a1),(a2)       save old value ...
        move.l  a3,(a1)         ... and set new vector
        addq.l  #4,d1           increment index register
        dbra    d0,inxt         repeat for all 3 vectors
done    rts

oldtab  dc.l    BIOSVEC,KBDVEC,TIMVEC   system vector locations
        dc.l    biosold,kbdold,timold   old vector values
        dc.l    biostrp,kbdtrp,timtrp   new vector values

* message area

msg     dc.b    CR,LF,TAB,'IDLE: the CRT protector'
        dc.b    CR,LF,TAB,'    by Moshe Braner'
        dc.b    CR,LF,TAB,'version 1.0 - installed',CR,LF,LF,0

        end
