/* copyright 1987, 1988, 1989 Phil Andrews, Pittsburgh Supercomputing Center */
/* the controlling module for the gplot program
   note that this is mostly a shell so that the main CGM module can be
   considered callable by other programs (inclusion of graphics with text) 
*/
#include <stdio.h>
#include "defs.h"
#define max_str 128
#define  version_str "4.3b2"
static struct info_struct new_info;
static struct one_opt new_opt[opt_size];
/* now the big locals, the structures which keep track of the CGM state */
static struct 	mf_d_struct 	glbl1;	/* the class 1 elements */
static struct 	pic_d_struct 	glbl2, dflt2;	/* the class 2 elements */
static struct 	control_struct	glbl3, dflt3;	/* the class 3 elements */
static struct 	attrib_struct	glbl5, dflt5;	/* the class 5 elements */

/* and now the arrays of function pointer, filled in externally by the
   device initialisation routine */
static int (*delim[Delim_Size])();	/* delimiter functions */
static int (*mfdesc[MfDesc_Size])();	/* metafile descriptor functions */
static int (*pdesc[PDesc_Size])();	/* page descriptor functions */
static int (*mfctrl[Control_Size])();	/* mf control functions */
static int (*gprim[GPrim_Size])();	/* graphical primitives */
static int (*attr[Att_Size])();		/* the attribute functions */
static int (*escfun[Esc_Size])();	/* the escape functions */
static int (*extfun[Ext_Size])();	/* the external functions */
static int (*ctrl[Delim_Size])();	/* external controller functions */
extern void s_defaults();		/* in utils.c */
/* now the main program */
main(argc, argv)
int argc;
char **argv;
{
int cmd_len, to_screen = 0, do_list = 0, random_file, pages_done;
char cmd_line[max_str];
char in_fname[max_str];		/* the input file name */
char open_name[max_str];	/* the opened file name */
char def_name[max_str];		/* default output file specification */
char full_oname[max_str];	/* full input file specification */
extern close_up();		/* in IO.C */
extern cgm_setup(), ccgm_setup();	/* binary and clear text setup */
extern get_cmd(), get_clear();		/* get next command */
extern cgm_command(), do_clear();	/* do the command */
int (*do_command)(), (*get_command)();	/* useful pointers */
unsigned char *start_mem = NULL;	/* for holding commands, data */
int mem_size = 512 * 1000;	/* intial mem we will use */
int get_cmd();	/* get the next command, return -1 if run out of data */
int p_len;	/* parameter length */
static struct ad_struct last_ad;	/* address of the last command read */
int class, element;

	initialise_time(); 			/* start the clock */

	pages_done = 0;
	/* get the command line */
#ifdef VMS
	strcpy(cmd_line, "GPT ");	/* our multi-purpose verb */
	cmd_len = strlen(cmd_line);	/* get the command line */
	if (!get_cmd_line(cmd_line + cmd_len, max_str - 1 - cmd_len, 0, NULL)){
	    fprintf(stderr, "trouble getting command line !\n");
	    exit(0);
	}
#endif

	/* check options */
	in_fname[0] = def_name[0] = '\0';
	if (!parse_cline(cmd_line, argc, argv, &to_screen,
	    &do_list, &new_info, new_opt)){
	    fprintf(stderr, "couldn't parse the command line !");
	    exit(0);
	}
	else {
	    /* now go ask the device what it thinks */
	    if (!dev_setup(new_opt, &new_info, 
	    	&glbl1, &glbl2, &glbl3, &glbl5, delim, mfdesc, pdesc, mfctrl, 
	    	gprim, attr, escfun, extfun, ctrl, &argc, argv))
		exit(0);	
	    /* and come to a conclusion */
	    consult_device(new_opt, &new_info);
	}

/* announce ourselves */
	if (!to_screen) fprintf(stderr, 
	    "Pittsburgh Supercomputing GPLOT %s\n", version_str);

	/* take care of the file names */

	if (new_opt[(int) in_name].set) 
	    strncpy(in_fname, new_opt[(int) in_name].val.str, max_str);

	if (new_opt[(int) out_name].set) 
	    strncpy(def_name, new_opt[(int) out_name].val.str, max_str);
	else {
#ifdef VMS
	    strncpy(def_name, new_info.out_name, max_str);
#endif
	}

	/* open the input file */
	if (!open_input_file(in_fname, open_name, !to_screen, 
	    (new_opt[(int) clear_text].set) ? ".cgmc" : ".cgm", 
	    full_oname, &new_info, new_opt[(int) clear_text].set,
	    &random_file)) {
	    fprintf(stderr, "GPLOT %s couldn't open your file !\n", 
	    	version_str);
	    exit(0);
	}

	/* open the output files */
	if (!open_output_file(open_name, def_name, do_list, &new_info)) {
	    (void) fprintf(stderr, "couldn't open output file\n");
	    exit(0);
	}

	/* set the defaults */
	s_defaults(&glbl1, &dflt2, &dflt3, &dflt5, &glbl5, 1.0);

/* now the ongoing loop */

	/* allocate main memory */
	start_mem = (unsigned char *) allocate_mem(mem_size, 0);
	if (!start_mem) exit(0);


	/* setup the command interpreters */
	if (new_opt[(int) clear_text].set) {
		if (!ccgm_setup(do_list, full_oname, version_str, &new_info, 
		new_opt, &glbl1, &glbl2, &dflt2, &glbl3, &dflt3, &glbl5, 
		&dflt5, delim, mfdesc, pdesc, mfctrl, gprim, attr, escfun, 
		extfun, ctrl)) {
		(void) fprintf(stderr, "couldn't setup clear text\n");
		exit(0);
	    } else {	/* setup pointers */
		get_command = get_clear;
		do_command = do_clear;
	    }
	}
	else {
	    if (!cgm_setup(do_list, full_oname, version_str, &new_info, 
		new_opt, &glbl1, &glbl2, &dflt2, &glbl3, &dflt3, &glbl5, 
		&dflt5, delim, mfdesc, pdesc, mfctrl, gprim, attr, escfun, 
		extfun, ctrl, random_file)) {
		(void) fprintf(stderr, "couldn't setup binary\n");
		exit(0);
	     } else {	/* setup pointers */
		get_command = get_cmd;
		do_command = cgm_command;
	    }
	}


	/* do the main loop while there is both input and not end_metafile */
	while  ( ((p_len = (*get_command)(&start_mem, &mem_size, &last_ad))
	     >= 0) && 
	    ((*do_command)(start_mem, p_len, &last_ad, &class, &element))) {
	    if ((class == 0) && (element == (int) E_Pic)) {
		/* just finished page */
		++pages_done;
	    }
	}

	if (p_len < 0) (void) fprintf(stderr, "premature end of file\n");
	write_time(pages_done);				/* show timings */

	close_up(0);				/* clean up */
	return(1);				/* may not get here */

}
