/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.database;

import gnu.prolog.database.Predicate;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.util.ArrayList;
import java.util.List;

public class Predicate_clause
extends ExecuteOnlyCode {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        Predicate p;
        if (backtrackMode) {
            ClauseBacktrackInfo bi = (ClauseBacktrackInfo)interpreter.popBacktrackInfo();
            interpreter.undo(bi.startUndoPosition);
            return this.nextSolution(interpreter, bi);
        }
        Term head = args[0];
        Term body = args[1];
        if (head instanceof VariableTerm) {
            PrologException.instantiationError();
        }
        CompoundTermTag tag = null;
        if (head instanceof AtomTerm) {
            tag = CompoundTermTag.get((AtomTerm)head, 0);
        } else if (head instanceof CompoundTerm) {
            tag = ((CompoundTerm)head).tag;
        } else {
            PrologException.typeError(TermConstants.callableAtom, head);
        }
        if (!Predicate_clause.isCallable(body)) {
            PrologException.typeError(TermConstants.callableAtom, body);
        }
        if ((p = interpreter.getEnvironment().getModule().getDefinedPredicate(tag)) == null) {
            return -1;
        }
        if (p.getType() != Predicate.TYPE.USER_DEFINED || !p.isDynamic()) {
            PrologException.permissionError(TermConstants.accessAtom, TermConstants.privateProcedureAtom, tag.getPredicateIndicator());
        }
        ArrayList<Term> clauses = new ArrayList<Term>();
        ClauseBacktrackInfo bi = new ClauseBacktrackInfo();
        Predicate predicate = p;
        synchronized (predicate) {
            for (Term term : p.getClauses()) {
                clauses.add((Term)term.clone());
            }
            if (clauses.size() == 0) {
                return -1;
            }
            bi.startUndoPosition = interpreter.getUndoPosition();
            bi.position = 0;
            bi.clauses = clauses;
            bi.clause = new CompoundTerm(TermConstants.clauseTag, head, body);
        }
        return this.nextSolution(interpreter, bi);
    }

    private int nextSolution(Interpreter interpreter, ClauseBacktrackInfo bi) throws PrologException {
        while (bi.position < bi.clauses.size()) {
            int rc;
            if ((rc = interpreter.unify(bi.clauses.get(bi.position++), bi.clause)) != 1) continue;
            interpreter.pushBacktrackInfo(bi);
            return 0;
        }
        return -1;
    }

    public static boolean isCallable(Term body) {
        if (body instanceof VariableTerm) {
            return true;
        }
        if (body instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)body;
            if (ct.tag == TermConstants.conjunctionTag || ct.tag == TermConstants.disjunctionTag || ct.tag == TermConstants.ifTag) {
                return Predicate_clause.isCallable(ct.args[0].dereference()) && Predicate_clause.isCallable(ct.args[1].dereference());
            }
            return true;
        }
        return body instanceof AtomTerm;
    }

    private static class ClauseBacktrackInfo
    extends BacktrackInfo {
        List<Term> clauses;
        int position;
        int startUndoPosition;
        Term clause;

        ClauseBacktrackInfo() {
            super(-1, -1);
        }
    }
}

