%{!?release: %define release 0}
%{!?version: %define version 4.0.3}

Name: ccscript
Summary: C++ class framework for script extensible applications.
Version: %{version}
Release: %{release}%{?dist}
License: GPLv3+
URL: http://www.gnu.org/software/ccscript
Group: Development/Libraries
Source0: http://www.gnutelephony.org/dist/tarballs/ccscript-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: gcc-c++
BuildRequires: ucommon-devel >= 2.0.0
BuildRequires: latex2html lynx

%description
GNU ccScript is a highly specialized embedded scripting engine and virtual 
execution environment for creating script "extensible" applications.  This 
system is a C++ class library which allows one to derive application 
specific dialects of the core language as needed through subclassing.

%define _libname libccscript4
%define _devname libccscript-devel

%package -n %{_libname}
Group: System/Libraries
Summary: Runtime library for ccscript framework
Provides: %{name} = %{version}-%{release}

%package -n %{_devname}
Requires: %{_libname} = %{version}
Requires: ucommon-devel >= 2.0.0
Group: Development/Libraries
Summary: Headers and static link library
Provides: %{name}-devel = %{version}-%{release}

%package doc
Group: Documentation
Summary: Documentation of ccscript engine

%description -n %{_libname}
This package contains the runtime library needed by applications that use 
the GNU ccScript engine.

%description -n %{_devname}
Static link and header files for building applications that use GNU ccScript.

%description doc
Documentation of scripting language and engine runtime system.

%changelog

%prep
%setup
%build

%configure CXXFLAGS="$RPM_OPT_FLAGS"
%{__make} %{?_smp_mflags} 

%install

%makeinstall
%{__strip} %{buildroot}/%{_libdir}/lib*.so.*.*

%clean
%{__rm} -rf %{buildroot}

%files -n %{_libname}
%defattr(-,root,root,-)
%doc AUTHORS README COPYING INSTALL NEWS SUPPORT ChangeLog
%{_libdir}/*.so.*

%files -n %{_devname}
%defattr(-,root,root,-)
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/*.la
%{_includedir}/ccscript.h
%{_libdir}/pkgconfig/*.pc
%attr(0755,root,root) %{_bindir}/ccscript-config

%files doc
%defattr(-,root,root,-)
%doc doc/*.html doc/*.pdf doc/*.text

%post -n %{_libname} -p /sbin/ldconfig

%postun -n %{_libname} -p /sbin/ldconfig

