/*
 * Stateful.java - 0.9.0    01/13/2001 - 17:13:37
 *
 * Copyright (C) 2000,2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.groboclown.util.states.v1;



/**
 *
 *
 * @author Matt Albrecht
 * @version 0.9.0 Alpha
 */
public class Stateful
{
    //---------------------------------------------------------------------
    // Public Static Fields
    
    
    //---------------------------------------------------------------------
    // Protected Static Fields
    
    
    //---------------------------------------------------------------------
    // Private Static Fields
    
    
    //---------------------------------------------------------------------
    // Public Fields
    
    
    //---------------------------------------------------------------------
    // Protected Fields
    
    
    //---------------------------------------------------------------------
    // Private Fields
    
    private IStatefulListener listener;
    private StateCategory category;
    private Object[] actions = null;
    private int currentState = -1;
    private Object currentAction = null;
    
    
    //---------------------------------------------------------------------
    // Constructors
    
    
    /**
     * Default Constructor
     */
    public Stateful( IStatefulListener listener )
    {
        if (listener == null)
        {
            throw new IllegalArgumentException("no null args" );
        }
        this.listener = listener;
    }
    
    
    
    
    
    //---------------------------------------------------------------------
    // Public Methods
    
    
    /**
     * 
     */
    public void addStateAction( State s, Object action )
    {
        if (this.category == null)
        {
            throw new IllegalStateException(
                "Stateful never intialized - you must add it to a set "+
                "before adding State Actions" );
        }
        if (!this.category.isOfCategory( s ))
        {
            throw new IllegalStateException(
                "State object not of state category");
        }
        this.actions[ s.getIndex() ] = action;
        
        if (s.getIndex() == this.currentState &&
            action != this.currentAction)
        {
            // The current state's action has changed
            this.listener.setAction( action );
            this.currentAction = action;
        }
    }
    
    /**
     * 
     */
    public void removeStateAction( State s )
    {
        addStateAction( s, null );
    }
    
    /**
     * Only calls the listener's setAction if the new state is different
     * than the current state, and the new state's action object is
     * different than the current action object.
     */
    public void setState( State s )
    {
        if (this.category == null)
        {
            throw new IllegalStateException(
                "Stateful never intialized - you must add it to a set "+
                "before adding State Actions" );
        }
        if (!this.category.isOfCategory( s ))
        {
            throw new IllegalStateException(
                "State object not of state category");
        }
        
        //
        // perform a series of checks to see if we need to
        // set this state.
        //
        
        // check if the state is identical to the current state
        int si = s.getIndex();
        if (si == this.currentState)
        {
            // do nothing - we're on the same state as we were
            return;
        }
        this.currentState = si;
        
        // now check if the new state's action object is identical
        // to the current action object.
        Object a = actions[ si ];
        if (this.currentAction == a)
        {
            // do nothing - the state changed, but the action didn't
            return;
        }
        this.currentAction = a;
        
        // we can set the state
        this.listener.setAction( actions[ s.getIndex() ] );
    }
    
    //---------------------------------------------------------------------
    // Protected Methods
    
    
    protected void initialize( StateCategory s )
    {
        if (this.actions != null)
        {
            throw new IllegalStateException("Stateful already initialized");
        }
        this.actions = new Object[ s.getMaximumStateCount() ];
        this.category = s;
    }
    
    //---------------------------------------------------------------------
    // Private Methods
    
    
}
 
