
#include "list_v.h"

////////////////////////////////////////////////////////////////////////
///										 IMPLEMENTATION	of list_v												 ///


/*
list_v::list_v	(void* t1) {
	initToNulllist();
	append(t1);
}

	
list_v::list_v	(void* t1, void* t2) {
	initToNulllist();
	append(t1);
	append(t2);
}

	
list_v::list_v	(void* t1, void* t2, void* t3) {
	initToNulllist();
	append(t1);
	append(t2);
	append(t3);
}

	
list_v::list_v	(void* t1, void* t2, void* t3, void* t4) {
	initToNulllist();
	append(t1);
	append(t2);
	append(t3);
	append(t4);
}
*/
void list_v::reverseInPlace() {
	if (isEmpty()) return;

	list_node_v *now;
	list_node_v *temp;
 
	now	=	_headPtr;

	while	(now !=	NULL)	{
		temp = now->_next;
		now->_next	=	now->_prev;
		now->_prev	=	temp;
		now	=	temp;
 	}
			
	temp = _headPtr;
	_headPtr	=	_tailPtr;
	_tailPtr	=	temp;

}

// Returns the length	of the list

int	list_v::length() const {
 //	Currently, steps through whole list	to find	length
 //	Could	cache	the	length in	an extra piece member	data if	this
 //	becomes	a	big	performance	hit	-	of course	that would add complexity
 //	to every other method	that modified	the	length of	lists...
	int	len	=	0;
	for	(list_pos_v	step(*this);step;++step) {
		len++;
	}
		
	return len;
}

// Returns the value of	the	n'th element of	the	list
void*	list_v::nth_element(int n) const {
	// we	start	at 1
	n--;
	list_pos_v step (*this);

	for	(;step.onlist() && n;n--) {
		step++;
	}
	return step;
}

// Returns the position	of 't' in	the	list,	or -1	if not there

int	list_v::positionOf(const void* const& t)	const	{
	int	count = 1;
	for(list_pos_v p(*this); p;p++, count++) {
		if (p == t) 
			return count;
	}
	return -1;
}

void list_v::trashlist()	{
	list_node_v *l = _headPtr, *m;
	while	(l)	{
		m	=	l->_next;
		delete l;
		l	=	m;
	}
}

void list_v::create_first_element(void* t)	{
	assert(_headPtr == NULL && _tailPtr == NULL);
	_headPtr = _tailPtr	= _alloc_node(NULL, t, NULL);
}

void list_v::append(void* t)	{
	if (isEmpty()) {
		create_first_element(t);
	}	else {
		list_node_v *oldTail	=	_tailPtr;		
		list_node_v *newTail	=	_alloc_node(_tailPtr, t,	NULL);
		oldTail->_next	=	newTail;
		_tailPtr		=	newTail;
	}
}



//----------------------------------------------------
//----------------------------------------------------

void list_v::remove(void* t)	{
 
	if	(isEmpty())	return;	
	 
	list_node_v	*now = _headPtr;

	while ( (now	!= NULL) &&	(now->_t	!= t)) {
		now = now->_next;
	}
	if	(now->_t==t)	{
		list_node_v	*pr	=	now->_prev;
		list_node_v	*ne	=	now->_next;
		if	(now ==	_headPtr)
			_headPtr = ne;
		else
			pr->_next	=	ne;
		if	(now ==	_tailPtr)
			_tailPtr = pr;
		else
			ne->_prev	=	pr;
		delete	now;
	} else	{
		assert(0);
		//cerr	<< "There	is no	such thing to	delete!";
	}

}


/* 
 * ostream&	operator<<(ostream&	o, const   list_v& l)	   {
 *	   o   << "list{" ;
 *	   for(list_node_v *ln = l._headPtr;
 *			   ln;
 *			   ln=ln->next)	{
 *		   o   << ln->t	<< (ln->next   ?   "   "   :   "");
 *	   }
 *	   o   << "}";
 *	   return o;
 * }
 */


void list_v::copyToNullFrom(const list_v&	l) {
	list_pos_v	tp(*this);
	for( list_pos_v lp(l); lp;	lp++) {
		tp.insertNext( lp.here_v() );
	}
}

list_v::list_v(const list_v& l)	{
	initToNulllist();
	copyToNullFrom(l);
}	

list_v& list_v::operator=(const	list_v& l)	{
	if ( this != &l) {
		trashlist();
		initToNulllist();
		copyToNullFrom(l);
	}
	return *this;
}

const list_v& list_v::operator+(const list_v& lt) const {
	list_v& newThis = _copy_me();
	list_v& newLT = lt._copy_me();
	newThis.appendAndDestroy(newLT);
	return newThis;
}

list_v& list_v::operator+=(const list_v& lt) {
	list_v& newLT = lt._copy_me();
	appendAndDestroy(newLT);
	return *this;
}

void list_v::appendAndDestroy(list_v&	lt)	{
	if(lt.isEmpty()) return;
	if(isEmpty())	{
		_headPtr	=	lt._headPtr;
		_tailPtr	=	lt._tailPtr;
		lt._headPtr		=	NULL;
		lt._tailPtr		=	NULL;
	}	else {
		list_node_v *thisTail = _tailPtr;
		list_node_v *ltHead	 =	 lt._headPtr;
		thisTail->_next = ltHead;
		ltHead->_prev	 = thisTail;
		_tailPtr	 = lt._tailPtr;
		lt._headPtr		=	NULL;
		lt._tailPtr		=	NULL;
	}
}


bool list_v::contains(const void* const& t) const {
	for(list_pos_v	p(*this); p; p++) {
		if ( p == t ) return true;
	}
	return false;
}

////////////////////////////////////////////////////////////////////////
//							IMPLEMENTATION of	list_pos														 //

list_pos_v::list_pos_v(list_v& l)	 {
	_cursor = l._headPtr;
	_tolist = &l;
	isConstPos = false;
}

list_pos_v::list_pos_v(const list_v& l) {
	_cursor = l._headPtr;
	_tolist = (list_v*)&l;
	isConstPos = true;
}

list_pos_v::list_pos_v(bool consty) {
	isConstPos = consty;
}

list_pos_v::list_pos_v(const list_pos_v& lp) {
	_cursor = lp._cursor;
	_tolist = lp._tolist;
	isConstPos = lp.isConstPos;
}

void list_pos_v::set_equal(const list_pos_v &lp) {
	if (this !=	&lp) {
		_cursor = lp._cursor;
		_tolist = lp._tolist;
		isConstPos = lp.isConstPos;
	}
}

bool list_pos_v::operator<(const list_pos_v& b)	const	{
	if ((b.reallyOnlist() && (reallyOnlist())))	{
		list_pos_v	step(*_tolist);
		while (step) {
			step++;
			if (step == b) {
				return true;
			}
		}
	}
	return false;
}

void* list_pos_v::here_v() const {
	assert(onlist());
	return _cursor->_t;
}

void list_pos_v::insertNext(void* t) {
	assert(!isConst());
	if ( mylist_v()->isEmpty() ) {
		mylist_v()->create_first_element(t);
		_cursor = mylist_v()->_headPtr;
		return;
	}
	assert(onlist());
	
	list_node_v *oldPrev	=	_cursor;
	list_node_v *oldNext	=	_cursor->_next;
	list_node_v *newNode	=	mylist_v()->_alloc_node(oldPrev, t,	oldNext);
	oldPrev->_next	=	newNode;
	if(oldNext)	
		oldNext->_prev	=	newNode;
	if(oldPrev ==	mylist_v()->_tailPtr) 
		mylist_v()->_tailPtr = newNode;
	_cursor = newNode;
}


void list_pos_v::insertPrev(void* t)	{
	assert(!isConst());
	if (mylist_v()->isEmpty())	{
		mylist_v()->create_first_element(t);
		_cursor = mylist_v()->_tailPtr;
	}
	assert(onlist());
	list_node_v *oldPrev	=	_cursor->_prev;
	list_node_v *oldNext	=	_cursor;
	list_node_v *newNode	=	mylist_v()->_alloc_node(oldPrev, t,	oldNext);
	oldNext->_prev	=	newNode;
	if(oldPrev)	
		oldPrev->_next	=	newNode;
	if(oldNext ==	mylist_v()->_headPtr) 
		mylist_v()->_headPtr = newNode;
	_cursor = newNode;
}

bool list_pos_v::reallyOnlist() const {
	list_pos_v	b(*mylist_v());

	if (!onlist()) return	false;

	while	(b.onlist()) {
		if (b	== *this)	{
			return true;
		}
		b.goNext();
	}

	return false;
}


void list_pos_v::delete0()	{
	if (offlist()	|| isConstPos) 
		return;
	list_node_v * pre = _cursor->_prev;
	list_node_v * nex = _cursor->_next;
	if (mylist_v()->_headPtr	== _cursor) {
	 	// Deleting	first	element	of list...
		mylist_v()->_headPtr	=	nex;
	}	else {
		pre->_next	=	nex;
	}
	if (mylist_v()->_tailPtr	== _cursor) {
		// Deleting	last element of	list.
		// Note	that we	might	also be	deleting the first (=only) element too...
		mylist_v()->_tailPtr	=	pre;
	}	else {
		nex->_prev	=	pre;
	}
	delete _cursor;
	_cursor = NULL;
}


void list_pos_v::deleteAndGoNext()	{
	list_pos_v&	n	=	*this;
	n.goNext();
	delete0();
	*this	=	n;
}


void list_pos_v::replaceWith(void*	t) {
	assert(onlist() && !isConstPos);
	_cursor->_t	=	t;
}

////////////////////////////////////////////////////////////////////////

#if 0
// Creates a new list, initialized by	the	first	n	elements of	array	at.	

list_v::list_v(void*	*at, int n)	
{
	int	i;
	
	initToNulllist();
	for	(i=0;	i<n; i++)	{
		append(at[i]);
	}	
}

// Allocates a new array whose elements	are	the	elements of	the	list
// The caller	of toArray assumes responsibility	for	disposing	of the
//	 memory	obtained for the array.
// If	the	list is	empty, NULL	is returned	and	no mem is	allocated.
// If	there	are	problems allocating	mem	or accessing the list, 
//	 the function	exits	the	program.

void*	*list_v::toArray()	const	
{
	void*	*newArray;
	int	n	=	length();
	 int i;							
	list_pos_v	step = headConst();
	
	// If	list is	empty	then bail
	if (n	== 0)	return NULL;
	
	if (!(newArray = new void*[n]))	{
		//cerr <<	"list.toArray: Unable	to allocate	array	of size	"	<< n <<	"\n";
		exit(1);
	}

		// Invariant:	Elements 0..i-1	of the list	have been	inserted into	array
	for	(i=0;	i	<	n-1	;	step.goNext(), i++)	{
		 if	(step.onlist())	
			 newArray[i] = step.item_v();
			else {
			 //cerr	<< "list.toArray:	Error	accessing	element	at list	loc	"	<< i <<	"\n";
			 exit(1);
		 }
	}

	 //	We save	inserting	the	the	last element so	that we	can	do another simple
	 //	sanity check - namely	that we	are	truly	at the last	element	of the
	 //	list.

	// Assert: elements	0..n-2 have	been added to	list & n>0 
	if (step.atTail()	&& step.onlist())
		 newArray[n-1] = step.item_v();
	else {
		 //cerr	<< "list.toArray:	Didn't reach end of	list\n";
		 exit(1);
	}

	return newArray;
}

// through(b)
//	 Returns a list	starting at	this and going through b.

list_v	list_pos_v::through(const list_pos_v b)	const	{
	list_pos_v	a	=	*this;
	list_v	templist;

 
	// Make	sure a and b are on	the	list
/*	if (!a.reallyOnlist()	|| !b.reallyOnlist())
		return templist;

	// Make	sure a is	before b
	else	if (!(a	== b)	|| !(a < b))
		return templist;
*/

	// Copy	all	elements from	a	to b into	the	new	list
	do {
		templist.append(a.item_v());
		a.goNext();
	}	while	(!(a==b));

	templist.append(b.item_v());

	// Return	the	list
	return templist;
}


#endif

