/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFParser;
import de.tu_darmstadt.sp.paul.PDFReference;
import de.tu_darmstadt.sp.paul.PDFReferenceContainer;
import de.tu_darmstadt.sp.paul.PDFWriter;
import de.tu_darmstadt.sp.paul.ParseException;
import de.tu_darmstadt.sp.util.ArrayMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PDFDictionary
extends PDFReferenceContainer
implements Cloneable {
    Map content;
    boolean resolved;

    public PDFDictionary() {
        this.content = new ArrayMap(3);
    }

    public PDFDictionary(PDFDictionary dict) {
        this.content = new ArrayMap(dict.content);
        this.resolved = dict.resolved;
        this.direct = dict.direct;
    }

    protected Object clone() {
        return new PDFDictionary(this);
    }

    public boolean containsKey(PDFName key) {
        if (key == null) {
            throw new NullPointerException("key of a PDFDictionary may not be null");
        }
        return this.content.containsKey(key);
    }

    public boolean containsKey(String key) {
        return this.content.containsKey(PDFName.forString(key));
    }

    protected boolean deepEquiv(PDFReferenceContainer obj, Map compared) {
        Map otherContent = ((PDFDictionary)obj).content;
        if (this.content.size() != otherContent.size()) {
            return false;
        }
        Iterator myKeyIter = this.content.keySet().iterator();
        while (myKeyIter.hasNext()) {
            PDFName myKey = (PDFName)myKeyIter.next();
            PDFObject myValue = (PDFObject)this.content.get(myKey);
            PDFObject otherValue = (PDFObject)otherContent.get(myKey);
            if (otherValue == null) {
                return false;
            }
            if (!(myValue instanceof PDFReferenceContainer ? !((PDFReferenceContainer)myValue).dfsEquiv(otherValue, compared) : !myValue.equiv(otherValue))) continue;
            return false;
        }
        return true;
    }

    public PDFObject get(PDFName id) {
        if (id == null) {
            throw new NullPointerException("id of a PDFDictionary may not be null");
        }
        return (PDFObject)this.content.get(id);
    }

    public PDFObject get(String id) {
        return (PDFObject)this.content.get(PDFName.forString(id));
    }

    void getReferenced(PDFWriter writer) {
        Iterator iter = this.content.keySet().iterator();
        writer.markVisited(this);
        while (iter.hasNext()) {
            PDFName key = (PDFName)iter.next();
            if (!key.isDirect()) {
                throw new RuntimeException("Indirect key object found in dictionary.");
            }
            PDFObject value = this.get(key);
            if (!value.isDirect()) {
                this.put(key, (PDFObject)writer.getPDFRefFor(value));
            }
            if (writer.isVisited(value)) continue;
            value.getReferenced(writer);
        }
    }

    public Iterator iterator() {
        return Collections.unmodifiableMap(this.content).keySet().iterator();
    }

    public void put(PDFName id, PDFObject val) {
        if (id == null) {
            throw new NullPointerException("id of a PDFDictionary may not be null");
        }
        if (val == null) {
            throw new NullPointerException("val of a PDFDictionary may not be null(id=" + id.toString() + ")");
        }
        this.content.put(id, val);
    }

    public void put(String id, PDFObject val) {
        this.put(PDFName.forString(id), val);
    }

    public void remove(PDFName key) {
        if (key == null) {
            throw new NullPointerException("key of a PDFDictionary may not be null");
        }
        this.content.remove(key);
    }

    public void remove(String key) {
        this.content.remove(PDFName.forString(key));
    }

    void removeReferences(PDFWriter writer) {
        Iterator iter = this.content.keySet().iterator();
        writer.markVisited(this);
        while (iter.hasNext()) {
            PDFName key = (PDFName)iter.next();
            if (!key.isDirect()) {
                throw new RuntimeException("Indirect key object found in dictionary.");
            }
            PDFObject value = this.get(key);
            if (value instanceof PDFReference) {
                value = ((PDFReference)value).getContent();
                this.put(key, value);
            }
            if (writer.isVisited(value)) continue;
            value.removeReferences(writer);
        }
    }

    public void resolveReferences(PDFParser parser) throws ParseException, IOException {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        Set entries = this.content.entrySet();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry current = i.next();
            if (current.getValue() instanceof PDFReference) {
                PDFObject obj = parser.getObj((PDFReference)current.getValue());
                this.content.put(current.getKey(), obj);
                continue;
            }
            parser.resolveObject((PDFObject)current.getValue());
        }
    }

    public int size() {
        return this.content.size();
    }

    public String toString() {
        return "PDFDictionary wit KeySet: " + this.content.keySet().toString();
    }

    public void write(Writer out) throws IOException {
        Iterator iter = this.content.keySet().iterator();
        out.write("<<\n");
        while (iter.hasNext()) {
            PDFName key = (PDFName)iter.next();
            PDFObject value = this.get(key);
            key.write(out);
            out.write(32);
            value.write(out);
            out.write(10);
        }
        out.write(">>");
    }
}

