;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;            (c) copyright 1991  kent state university                 ;;;
;;;  Translated from franz to CL Jan. 1991            pwang              ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;=============================================================================
;    (c) copyright 1988  Kent State University
;               all rights reserved.
;=============================================================================
(in-package 'maxima)
(macsyma-module texetting)

;; mctex-lib must be set as a directory name where your mctex files are located
;; In this example, I set it as "/usr/local/maxima/kent/chokchai"
(setq mctex-lib "/usr/local/maxima/kent/chokchai")


;;	Project : McTeX
;;	Program : McLaTeX & McTeX
;;	Author  : Chokchai Leangsuksun
;;	TermProject for Computer Algebra Fall 1987
;;	Instructor : Prof. Paul S. Wang
;;	Purpose: To produce TeX or LaTeX code from
;;		mathematical expressions in Vaxima
;;
;;	Interfaced system: Vaxima 2.04 on Unix 4.2BSD Vax 11/780
;;	Language : Franz Lisp
;;
;;	Description of Algorithm
;;
;;		This program applies the object-orient technique
;;	for producing the TeX or LaTeX form. From the macsyma internal
;;	expression, the kernal will determine an object (which is an operator)
;;	then passes the method of the object which is stored in database.
;;	If the object is in a class of infix, the kernal will get a 
;;	fucntion to deal with an infix expression, and so on.
;;	The objects can be infix , prefix , postfix , exponential etc.
;;
;;	Layout of The Program
;;		1) Driver : TeX or LaTeX
;;		2) Kernal : tex_engine
;;		3) Method : functions to handle for each particular
;;			    operator
;;		4) Database : Properties list (object and its class)
;;		5) Utilities
;;
;;	User Documentation:  In file McTeX.tex
;;


;; special variables used in TeXetting
(proclaim '(special ccol texport $texautolabel $texworksheet $latexworksheet
             $texlabelleft $latexautolabel $texdisplaytype $texevaluate
             mactex-lib lop rop $labels casep))


;;****************************************************************************
;;	Program : McTeX Main Body
;;****************************************************************************

;;parsing the expression which should be in the form of
;;		tex(eqn[,filename[,t (d)]])  in C-line
;;if given just Tex(eqn);
;;if TeX(eqn,filename);
;; if autolabel mode is set
;; maybe it is a function?
;;exclude strings, numbers
;; if autolabel mode
;; if autolabel mode
;;labeling on left
;;print label on right hand side
(defmfun $latex (&rest margs)
         (prog (ccol displaytype filename mexplabel mexpress texport x
                     y eqnline)
           (setq mexpress (car margs))
           (setq ccol 1)
           (cond
             ((null mexpress) (princ "NO EXPRESSION GIVEN")
              (return nil))
             ((null (cdr margs)) (setq filename nil) (setq texport t))
             ((null (cddr margs)) (setq filename (cadr margs))
              (setq texport
                    (open (fullstrip1 (cadr margs)) :direction :output 
		                                    :if-exists :append)))
             (t (princ "wrong No. of Arguments given")))
           (cond
             ((member mexpress $labels :test #'eq)
              (setq mexplabel
                    (intern (concatenate 'string "("
                                (princ-to-string (fullstrip1 mexpress))
                                ")")))
              (setq mexpress (eval mexpress)))
             (t (setq mexplabel nil)
                (when $texevaluate (setq mexpress (meval mexpress)))))
           (when $texautolabel (setq mexplabel (updateautolabel)))
           (when (symbolp (setq x mexpress))
             (setq x ($verbify x))
             (cond
               ((setq y (mget x 'mexprer))
                (setq mexpress
                      (list '(mdefine) (cons (list x) (cdadr y))
                            (caddr y))))
               ((setq y (mget x 'mmacro))
                (setq mexpress
                      (list '(mdefmacro) (cons (list x) (cdadr y))
                            (caddr y))))
               ((setq y (mget x 'aexpr))
                (setq mexpress
                      (list '(mdefine)
                            (cons (list x 'array)
                                  (cdadr y))
                            (caddr y))))))
           (when (and (consp mexpress) (consp (car mexpress))
                      (eq 'mlable (caar mexpress)))
             (setq mexpress (cadr mexpress)))
           (cond
             ((and $latexworksheet
                   (when mexplabel
                     (member 'c (explode mexplabel) :test
                             #'eq)))
              (format texport "\\begin{verbatim}~%~a " mexplabel)
              (mgrind mexpress texport)
              (format texport ";~%\\end{verbatim}~%"))
             ((and $texworksheet
                   (when mexplabel
                     (member 'c (explode mexplabel) :test
                             #'eq)))
              (format texport "|~a " mexplabel)
              (mgrind mexpress texport) (format texport ";|~%"))
             (t (cond
                  ($latexautolabel
                      (format texport "\\begin{equation}~%"))
                  ($texdisplaytype (tprinc "$$"))
                  (t (tprinc "$")))
                (tex_engine mexpress 'mparen 'mparen)
                (cond
                  ($latexautolabel
                      (format texport "~%\\end{equation}~%"))
                  ($texdisplaytype
                      (when mexplabel
                        (if $texlabelleft
                            (format texport "\\leqno{\\tt ~a}" mexplabel)
                            (format texport "\\eqno{\\tt ~a}" mexplabel)))
                      (tprinc "$$") (myterpri))
                  (t (tprinc "$")))))
           (when filename (terpri texport) (close texport))
           (return 'done)))

;;****************************************************************************
;;	Program : McTeX Main Body
;;****************************************************************************
;;parsing the expression which should be in the form of
;;		tex(eqn[,filename[,t (d)]])  in C-line
;;if given just Tex(eqn);
;;if TeX(eqn,filename);
;; if autolabel mode is set
;; maybe it is a function?
;;exclude strings, numbers
;; if autolabel mode
;; if autolabel mode
;;labeling on left
;;print label on right hand side
(defmfun $tex (&rest margs)
         (prog (ccol displaytype filename mexplabel mexpress texport x
                     y eqnline)
           (setq mexpress (car margs))
           (setq ccol 1)
           (cond
             ((null mexpress) (princ " NO EXPRESSION GIVEN ")
              (return nil))
             ((null (cdr margs)) (setq filename nil) (setq texport t))
             ((null (cddr margs)) (setq filename (cadr margs))
              (setq texport
                    (open (fullstrip1 (cadr margs)) :direction :output 
			:if-exists :append)))
             (t (princ " wrong No. of Arguments given ")))
           (cond
             ((member mexpress $labels :test #'eq)
              (setq mexplabel
                    (intern (concatenate 'string "("
                                (princ-to-string (fullstrip1 mexpress))
                                ")")))
              (setq mexpress (eval mexpress)))
             (t (setq mexplabel nil)
                (when $texevaluate (setq mexpress (meval mexpress)))))
           (when $texautolabel (setq mexplabel (updateautolabel)))
           (when (symbolp (setq x mexpress))
             (setq x ($verbify x))
             (cond
               ((setq y (mget x 'mexprer))
                (setq mexpress
                      (list '(mdefine) (cons (list x) (cdadr y))
                            (caddr y))))
               ((setq y (mget x 'mmacro))
                (setq mexpress
                      (list '(mdefmacro) (cons (list x) (cdadr y))
                            (caddr y))))
               ((setq y (mget x 'aexpr))
                (setq mexpress
                      (list '(mdefine)
                            (cons (list x 'array)
                                  (cdadr y))
                            (caddr y))))))
           (when (and (consp mexpress) (consp (car mexpress))
                      (eq 'mlable (caar mexpress)))
             (setq mexpress (cadr mexpress)))
           (cond
             ((and $latexworksheet
                   (when mexplabel
                     (member 'c (explode mexplabel) :test #'eq)))
              (format texport "\\begin{verbatim}~%~a " mexplabel)
              (mgrind mexpress texport)
              (format texport ";~%\\end{verbatim}~%"))
             ((and $texworksheet
                   (when mexplabel
                     (member 'c (explode mexplabel) :test
                             #'eq)))
              (format texport "|~a " mexplabel)
              (mgrind mexpress texport) (format texport ";|~%"))
             (t (cond
                  ($latexautolabel
                      (format texport "\\begin{equation}~%"))
                  ($texdisplaytype (tprinc "$$"))
                  (t (tprinc "$")))
                (tex_engine mexpress 'mparen 'mparen)
                (cond
                  ($latexautolabel
                      (format texport "~%\\end{equation}~%"))
                  ($texdisplaytype
                      (when mexplabel
                        (if $texlabelleft
                            (format texport "\\leqno{\\tt ~a}" mexplabel)
                            (format texport "\\eqno{\\tt ~a}" mexplabel)))
                      (tprinc "$$") (myterpri))
                  (t (tprinc "$")))))
           (when filename (terpri texport) (close texport))
           (return 'done)))

;*************************************************************************
;;
;;				Utilities Section
;;
;*************************************************************************

;;; tprinc is an intelligent low level printing routine.  it keeps track of 
;;; the size of the output for purposes of allowing the TeX file to
;;; have a reasonable line-line. tprinc will break it at a space 
;;; once it crosses a threshold.
;;; this has nothign to do with breaking the resulting equations.
 
;-      arg:    chstr -  string or number to princ
;-      scheme: This function keeps track of the current location
;-              on the line of the cursor and makes sure
;-              that a value is all printed on one line (and not divided
;-              by the crazy top level os routines)
 
;would have exceeded the line length
; lead off with a space for safety
;so we split it up.
(defun tprinc (chstr)
  (prog (chlst)
    (cond ((> (+ (length (setq chlst (exploden chstr))) ccol) 70)
        (terpri texport) (setq ccol 1) (tprinc " ")))
    (do ((ch chlst (cdr ch)) (colc ccol (1+ colc)))
        ((null ch) (setq ccol colc))
      (write-char (car ch) texport))))

;;	myterpri acts like terpri but it is higher level than 
;;terpri

(defun myterpri ()
  (if texport (terpri texport) (mterpri))
  (setq ccol 1))

;;	lastlementp is a predicate function to check a list l
;;that is there only one element left in the list.

(defun lastelementp (l) (when (equal (length l) 1)))

;; 	getsymbol is a function tool. It'll  get the information
;;from the database which is a symbol for an argument (atom)

(defun getsymbol (atom) (get atom 'chchr))

;; 	get_process is a function tool. It'll  get the information
;;from the database about the process to handle the operator (atom)

(defun get_process (atom) (get atom 'texprocess))


;;   	setup is a function to build the database (put properties) for 
;;each key word

; check if property exists already
(defun setup (arg)
  (mapc #'(lambda (ls) (setf (get (car arg) (car ls)) (cadr ls)))
        (cdr arg)))

;; type in all the greek letters and other funny stuff that TeX
;;	tex-lbp and tex-rbp are the functions to get information
;;about size of the particular operator
(defun tex-lbp (x) (cond ((get x 'tex-lbp)) (t (lbp x))))

(defun tex-rbp (x) (cond ((get x 'tex-rbp)) (t (rbp x))))

;;	updateautolabel is a function to automate labeling for an
;;expression

(defun updateautolabel ()
  (let ((temp))
    (setq temp $texautolabel)
    (cond
      ((not (numberp temp))
       (merror "Error texautolabel must be set to be an integer"))
      (t (setq $texautolabel (1+ $texautolabel))
         (intern (concatenate 'string "(" (princ-to-string temp) ")"))))))


;;	$worksheet is a macsyma top level function which is a tool to
;;produce a macsyma worksheet. It can record from the begining until
;;to the current label if not specifying a 2 nd arg. In the other hand
;;we can specify which labels we  would like to record by issuing the
;;2 nd arg to be a list of the macsyma labels.
;;	a needed arg is a filename which is a string
;;
;;	lambda: $worksheet("filename"[,'[list of labels]]);
;;	arg1  : filename
;;	arg2(optional) : '[list of macsyma labels] note we must quote for
;;			 the 2nd arg.
;;error checking for 1st arg
;;error checking for 2nd arg
;;check work sheet mode for TeX
(defmfun $worksheet (filename &optional l)
         (when (not (eq '& (car (explode filename))))
           (merror "1ST ARG MUST BE A STRING"))
         (when l
           (when (or (not (listp l)) (atom (car l))
                     (not (eq 'mlist (caar l))) (listp (cadr l)))
             (merror "2ND ARGUMENT MUST BE A QUOTED LIST OF LABELS")))
         (cond
           ($texworksheet)
           ($latexworksheet)
           (t (merror "Please specify texworksheet() for TeX or latexworksheet()for LaTeX")))
         (do ((l1 (if l (cdr l) (reverse (cdr $labels))) (cdr l1)))
             ((null l1) filename)
           (mapply '$latex
                   `(,(car l1)
                        ,filename)
                   nil)))


;; 	$texworksheet is a macsyma top level function which initialize
;;the work sheet mode

(defmfun $texworksheet nil (setq $texworksheet t)
         (setq $latexworksheet nil) (setq $texlabelleft t)
         (setq $texautolabel nil) (setq $latexautolabel nil) '$done)

(defmfun $latexworksheet nil (setq $texworksheet nil)
         (setq $latexworksheet t) (setq $texlabelleft t)
         (setq $texautolabel nil) (setq $latexautolabel nil) '$done)


;;	$texinit is a top level macsyma function. It initialze a TeX
;; file wich we want to put math expression into it. So we have to
;; issuse this function before we execute tex(exp[,filename]) in order
;; to copy TeX macro filename to the header of the filename.
;;	arg : "filename" or filename (without quote)
;;
;with "filename"
;; copy header from some generic place
;extra slashes for maclisp // = /
(defmfun $texinit (filename)
         (let ((fname (if (eq '& (explode filename))
                          (apply 'concat
                              (cdr (explode filename)))
                          (stripdollar filename))))
           (when (numberp fname)
             (merror "FILENAME MUST BE A STRING"))
           (system (concatenate 'string "cat "
                         mctex-lib  "/verbatim.tex >> "
                                      (princ-to-string fname))))
            filename
 )


;; This $texend  prints a \\end on the filename
;;	arg : "filename" or filename (without quote)
;;
;with "filename"
(defun $texend (filename)
  (let ((fname (if (eq '& (explode filename))
		   (apply 'concat
                       (cdr (explode filename)))
                   (stripdollar filename))))
    (when (numberp fname) (merror "FILENAME MUST BE A STRING"))
    (format (open fname :direction :output :if-exists :append) "\\end~%"))
  filename)

;;	$texall is an easy worksheet recorder. It records all macsyma
;; c-line and d-line from the begining til current one.

(defmfun $texall (filename) ($texworksheet) ($texinit filename)
         ($worksheet filename) ($texend filename) filename)

;;	$latexinit is a top level macsyma function. It initialze a LaTeX
;; file wich we want to put math expression into it. So we have to
;; issuse this function before we execute tex(exp[,filename]) 
;; Also there are 2 options we can choose or choose both
;;	1) 2nd arg is a document style . It can be
;;		"article book letter report"
;;	2) 3rd arg is apoint size. It must come together with doumentstyle
;;
;;	arg1 : "filename" or filename (without quote)
;;	arg2 : style of doucument which is "article book letter report" without
;; ""quotation mark
;;	arg3 : point size must be integer 11 or 12 (10 is defualt don't specify)
;;
;;	latexinit(filename[,style[,pt]])
;;	
;filename can be "string" or string(without quote)
;with "filename"
;doumentstyle given
;point size given 10 is a default don't say 10
(defmfun $latexinit (filename &optional style pt)
         (let ((fname (if (eq '& (explode filename))
			   (apply 'concat
                              (cdr (explode filename)))
                          (stripdollar filename)))
               (texport) (sty (fullstrip1 style)))
           (if (numberp fname) (merror "FILENAME MUST BE A STRING")
               (setq texport (open fname :direction :output :if-exists :append)))
           (when style
             (cond
               ((member sty '(article book letter report) :test
                        #'equal)
                (if pt
                    (cond
                      ((and (numberp pt)
                            (member pt '(11 12) :test #'eq))
                       (format texport
                               (intern (concatenate 'string
                                        "\\documentstyle["
                                        (princ-to-string pt) "pt" "]{"
                                        (princ-to-string sty) "}~%"))))
                      (t (close texport)
                         (merror "WRONG PT SIZE MUST BE 11 OR 12")))
                    (format texport
                            (intern (concatenate 'string
                                     "\\documentstyle{"
                                     (princ-to-string sty) "}~%")))))
               (t (close texport)
                  (merror "WRONG DOCUMENTSTYLE IN 2ND ARG"))))
           (format texport "\\begin{document}~%")
           (close texport))
         filename)


;; This $latexend  prints a \\end{document} on the filename
;;	arg : "filename" or filename (without quote)
;;
;with "filename"
(defun $latexend (filename)
  (let ((fname (if (eq '& (explode filename))
		   (apply 'concat
                       (cdr (explode filename)))
                   (stripdollar filename))))
    (when (numberp fname) (merror "FILENAME MUST BE A STRING"))
    (format (open fname :direction :output :if-exists :append)
		   "\\end{document}~%"))
  filename)

;;	latexall is an easy worksheet recorder. It records all macsyma
;; c-line and d-line from the begining til current one.
(defun $latexall (filename)
  ($latexworksheet)
  ($latexinit filename '$article)
  ($worksheet filename)
  ($latexend filename)
  filename)


;; tex display style mode on
(defun $texdisplaytype () (setq $texdisplaytype t) '$done)

;; tex text style mode on
(defun $textexttype () (setq $texdisplaytype nil) '$done)


;; macsyma eval mode on
(defun $texeval () (setq $texevaluate t) '$done)


;; macsyma eval mode off
(defun $texnoeval () (setq $texevaluate nil) '$done)

;; tex left labeling mode
(defun $texlabelleft ()
  (setq $texlabelleft t)
  (setq $texdisplaytype t)
  '$done)

;; tex left labeling mode
(defun $texlabelright ()
  (setq $texlabelleft nil)
  (setq $texdisplaytype t)
  '$done)



(defun $texautolabel (n)
  (when (not (integerp n)) (merror "LABEL MUST BE AN INTEGER"))
  (setq $texworksheet nil)
  (setq $latexworksheet nil)
  (setq $texdisplaytype t)
  (setq $texautolabel n)
  (setq $latexautolabel nil)
  '$done)

(defun $latexautolabel (&optional n)
  (when n (merror "Should not have arg"))
  (setq $texworksheet nil)
  (setq $latexworksheet nil)
  (setq $texlabelleft nil)
  (setq $texdisplaytype t)
  (setq $texautolabel nil)
  (setq $latexautolabel t)
  '$done)

;; set default back to texetting
;set TeX worksheet mode false
;set LaTeX worksheet mode false
;set Tex or LaTeX left Labeling mode false
;set default for TeX or LaTeX in display type
;set default for evaluating macsyma expression
;set autolabel mode off, can be set to be integer
;set LaTeX autolabel mode false
(defun $texdefault ()
  (setq $texworksheet nil)
  (setq $latexworksheet nil)
  (setq $texlabelleft nil)
  (setq $texdisplaytype t)
  (setq $texevaluate t)
  (setq $texautolabel nil)
  (setq $latexautolabel nil)
  '$done)

;; reduce lbp and rbp value for mtimes to get less parentesis
(defun $lessparen ()
  (setf (get 'mtimes 'tex-lbp) '110)
  (setf (get 'mtimes 'tex-rbp) '110)
  '$done)
;; get back to normal case for paren
(defun $parenback ()
  (setf (get 'mtimes 'tex-lbp) '120)
  (setf (get 'mtimes 'tex-rbp) '120)
  '$done)
;;	tex_engine is a kernal fuction for this program. It checks whether
;;an argument "mexpress" is an atom or expression. Then it will assign
;;a proper function to the expression or just print if it is an atom.
;;This is an applied object-oriented programming technique.

;;	arg: mexpress - macsyma internal representaton
;;	     lop , rop - left and right handside operator of mexpress

;;special check if expression is an array
;;check whether or not to put parenthesis 
;;if not a keyword,it is a function
(defun tex_engine (mexpress lop rop)
  (setq mexpress (nformat mexpress))
  (if (atom mexpress) (tprinc (tex-atom mexpress))
      (when (listp (car mexpress))
        (cond
          ((member 'array (car mexpress) :test #'eq)
           (tex-array mexpress))
          ((or (<= (tex-lbp (caar mexpress)) (tex-rbp lop))
               (> (tex-lbp rop) (tex-rbp (caar mexpress))))
           (tex-paren mexpress))
          (t (if (get_process (caar mexpress))
                 (funcall (get_process (caar mexpress)) mexpress)
                 (tex-function mexpress)))))))




;;	tex-abs is a function to handle abs()

(defun tex-abs (mexpress)
  (tprinc "{\\left\\vert{")
  (tex_engine (cadr mexpress) 'mparen 'mparen)
  (tprinc "}\\right\\vert}"))
;;	when the operator is array ,this function will be called
;;	ex. a[x1,..] is a top level representation
(defun tex-array (mexpress)
  (tex_engine (caar mexpress) lop 'mfunction)
  (tprinc "_{")
  (do ((l (cdr mexpress) (cdr l))) ((null l) (tprinc "}"))
    (tex_engine (car l) lop rop)
    (when (not (lastelementp l)) (tprinc ","))))

;;	tex-at is a function to handel at(..) function 
;;
(defun tex-at (mexpress)
  (tprinc "{")
  (tex_engine (cadr mexpress) lop rop)
  (tprinc "\\bigg\\vert_{")
  (tex_engine (caddr mexpress) 'mparen 'mparen)
  (tprinc "}")
  (tprinc "}"))
;;	in tex_engine ,whennever mexpress is an atom this function taking care 
;;of it by getting a TeX symbol if it exsits. Also it handles some word wich
;;has a reserved character for TeX

(defun tex-atom (chr)
  (cond
    ((numberp chr) (tex-num chr))
    ((get chr 'chchr))
    (t (apply 'concat
           (mapcar #'handle_rsw
                   (rm '// (explode (fullstrip1 chr))))))))

;; it does like remove , but it is written because when compiled, what
;; a heck remove is added which confuse TeXetting
(defun rm (a list)
  (do ((l list (cdr l)) (l2 nil)) ((null l) (reverse l2))
    (when (not (equal a (car l))) (setq l2 (cons (car l) l2)))))


;;	this fn is called by tex-atom ,it checks for a reserved char.
(defun handle_rsw (c)
  (if (member c '($ % &) :test #'equal) (get c 'char) c)) 

(setf (get '$ 'char) '"\\$")
(setf (get '% 'char) '"\\%")
(setf (get '& 'char) '"\\&")
(setf (get '_ 'char) '"\\_")

;;	tex-binomial :-
;;	 top level:  binomail(x,y);

(defun tex-binomial (mexpress)
  (tprinc "{")
  (tex_engine (cadr mexpress) 'mparen 'mparen)
  (tprinc "\\choose ")
  (tex_engine (caddr mexpress) 'mparen 'mparen)
  (tprinc "}"))



;;	tex-det is a function to handle determinant()

(defun tex-det (mexpress)
  (let ((operand (cadr mexpress)))
    (tprinc "{\\rm det}")
    (tex_engine operand 'mparen 'mparen)))

;;	tex-dif is a function to handle diferentiation function. 
;;It calls to subfunctions powerof_d and denopart.
;;
(defun tex-diff (mexpress)
  (cond
    ((powerof_d (cddr mexpress)) (denopart (cddr mexpress))
     (tprinc "}{") (tex_engine (cadr mexpress) 'mtimes rop)
     (tprinc "}"))
    (t (tex_engine (cadr mexpress) lop rop))))

;;if there is no repeating differentiation
;; just diff(exp,x)
;; if diff(exp,x,no,..)
(defun powerof_d (l)
  (cond
    ((lastelementp l) (tprinc "{d") (tprinc "\\over ") t)
    (t (do ((l1 l (cddr l1)) (l2 nil (cons (cadr l1) l2))
            (power_of_d nil))
           ((null l1) (setq power_of_d (addn l2 nil))
            (cond
              ((numberp power_of_d)
               (cond
                 ((equal 0 power_of_d) nil)
                 ((equal 1 power_of_d) (tprinc "{d\\over ") t)
                 (t (tprinc "{d^{") (tprinc power_of_d)
                    (tprinc "}\\over ") t)))
              (t (tprinc "{d^{")
                 (tex_engine power_of_d 'mparen 'mparen)
                 (tprinc "}\\over ") t)))))))

;;if just diff(exp,x)
;;if diff(exp,x,nox,y,noy,...)
(defun denopart (l)
  (prog (result)
    (cond
      ((lastelementp l) (tprinc "{") (tprinc "d")
       (tprinc (getsymbol 'mtimes)) (tex_engine (car l) 'mtimes rop)
       (tprinc "}"))
      (t (do ((l1 l (cddr l1)) (l2 nil)) ((null l1) (setq result l2))
           (setq l2
                 (cons (append '((mexpt)) (list (car l1))
                               (list (cadr l1)))
                       l2)))
         (setq result (muln result nil))
         (cond
           ((atom result) (tprinc "{d") (tprinc (getsymbol 'mtimes))
            (tex_engine result 'mparen 'mparen) (tprinc "}"))
           ((listp result)
            (cond
              ((eq (caar result) 'mexpt) (tprinc "{d")
               (tprinc (getsymbol 'mtimes))
               (tex_engine result 'mtimes 'mparen) (tprinc "}"))
              (t (tprinc "{")
                 (do ((l1 (cdr result) (cdr l1)) (l2 nil)
                      (power_of_d nil))
                     ((null l1) (tprinc "}"))
                   (tprinc "d")
                   (tprinc (getsymbol 'mtimes))
                   (tex_engine (car l1) 'mtimes 'mtimes)
                   (when (not (lastelementp l1)) (tprinc ",")))))))))))
	
;; this fuction is adopted the main idea form macTeX from Prof. Richard
;; Fateman in the tex-mexpt
;;
;; insert left-angle-brackets for mncexpt. a^<n> is how a^^n looks.
;; here is where we have to check for f(x)^b to be displayed
;; as f^b(x), as is the case for sin(x)^2 .
;; which should be sin^2 x rather than (sin x)^2 or (sin(x))^2. 
;; yet we must not display (a+b)^2 as +^2(a,b)...
;; or (sin(x))^(-1) as sin^(-1)x, which would be arcsine x
; this is f(x)
; this is f [or nil]
;this is (x) [maybe (x,y..), or nil]
;; this is the exponent
; there is such a function
;; insist it is a % or $ function
;     x
;;this case like sin(x)^x --> sin x
;; if for example exp = (x+2)^4
;;	in case x^^y
(defun tex-expt (mexpress)
  (cond
    ((eq (caar mexpress) 'mexpt)
     (let* ((fx (cadr mexpress))
            (f (and (not (atom fx)) (atom (caar fx)) (caar fx)))
            (bascdr (and f (cdr fx))) (expon (caddr mexpress))
            (doit (and f (member (char (string f) 0) '(% $) :test #'eq)
                       (not (member f '(%sum %product) :test #'eq)))))
       (cond
         (doit (cond
                 ((atom expon) (tprinc (tex-fname f)) (tprinc "^{")
                  (tprinc (tex-atom expon)) (tprinc "}")
                  (if (cdr bascdr) (tex-listparen bascdr)
                      (tex_engine (car bascdr) 'mtimes 'mtimes)))
                 (t (tprinc (tex-atom f)) (tex-listparen bascdr)
                    (tprinc "^{") (tex_engine expon 'mparen 'mparen)
                    (tprinc "}"))))
         (t (tex_engine (cadr mexpress) lop (caar mexpress))
            (tprinc "^{") (tex_engine (caddr mexpress) 'mparen 'mparen)
            (tprinc "}")))))
    (t (tex_engine (cadr mexpress) lop (caar mexpress))
       (tprinc "^{\\langle ")
       (tex_engine (caddr mexpress) 'mparen 'mparen)
       (tprinc "\\rangle}"))))
;;	this function will check that whether or not an arg has a symbol
;;in data base or not, if not it 'll be treated to be function which 'll
;;be printed in rm font
(defun tex-fname (f)
  (if (getsymbol f) (getsymbol f)
      (intern (concatenate 'string "{\\rm "
                  (princ-to-string (tex-atom f)) "}"))))
;;	to handle if an operator is a function which will be printed
;;in \\rm font
(defun tex-function (mexpress)
  (tprinc "{\\rm ")
  (tex_engine (caar mexpress) 'mparen 'mparen)
  (tprinc "}")
  (tex-listparen (cdr mexpress)))
;;	for infix operator , and also handle when there is a truncation
;;in macsyma expression (see tex-infix1)
;;	tex-infix calling
;;		1)tex-infix1 calling 
;;			1.1) p-op-oprd
;;		2)p-op-oprd
;;
;if -x or +x so call tex-function
(defun tex-infix (mexpress)
  (let ((moperator (car mexpress)) (moperands (cdr mexpress)))
    (cond
      ((equal (length moperands) 1) (tex-function mexpress))
      (t (tex_engine (car moperands) lop (car moperator))
         (p-op-oprd moperator (cadr moperands))
         (tex-infix1 moperator (cddr moperands))))))

(defun tex-infix1 (moperator moperands)
  (cond
    ((null moperands)
     (when (member 'trunc moperator :test #'equal)
       (tprinc (getsymbol (car moperator)))
       (tprinc "\\cdots ")))
    (t (p-op-oprd moperator (car moperands))
       (tex-infix1 moperator (cdr moperands)))))

;;	p-op-oprd is a function printing operator and operand consecutively
;;	ex	+ x	when + is a infix op and x is oprd

(defun p-op-oprd (moperator moperand)
  (let ((op (car moperator)))
    (cond
      ((equal op 'mplus)
       (cond
         ((listp moperand)
          (cond
            ((equal (caar moperand) 'mminus) (tprinc "-")
             (tex_engine (cadr moperand) 'mminus rop))
            (t (tprinc "+") (tex_engine moperand 'mplus rop))))
         (t (tprinc "+") (tex-atom moperand))))
      (t (tprinc (getsymbol op)) (tex_engine moperand op op)))))
    

;;	tex-intgrate handles an integration expression
;;	It will detect that integrate function is called in short form
;; or long form example: integrate(x^4,x,0,inf) is a long form.

;;short form
;;long form
(defun tex-integrate (mexpress)
  (tprinc "{\\int_{")
  (cond
    ((equal (length mexpress) 3) (tprinc "}{"))
    ((equal (length mexpress) 5)
     (tex_engine (cadddr mexpress) 'mparen 'mparen) (tprinc "}^{")
     (tex_engine (car (cddddr mexpress)) 'mparen 'mparen)
     (tprinc "} {"))
    (t (merror "Wrong NO. of Arguments")))
  (tex_engine (cadr mexpress) 'mparen 'mparen)
  (tprinc "}\\,d")
  (tprinc (getsymbol 'mtimes))
  (tex_engine (caddr mexpress) 'mparen rop)
  (tprinc "}"))

		      


;;	tex-limit takes care the "limit(exp,var,val,dir)"
(defun tex-limit (mexpress)
  (tprinc "\\lim_{")
  (tex_engine (caddr mexpress) 'mparen 'mparen)
  (tprinc "\\to ")
  (tex_engine (cadddr mexpress) 'mparen 'mapren)
  (when (car (cddddr mexpress))
    (if (member (car (cddddr mexpress)) '($minus $plus) :test #'equal)
        (tprinc (getsymbol (car (cddddr mexpress))))
        (merror "THE 4TH ARG MUST BE PLUS OR MINUS")))
  (tprinc "}{")
  (tex_engine (cadr mexpress) 'mparen rop)
  (tprinc "}"))
;;	This function handles a macsyma list expression 
;; 
(defun tex-list (mexpress)
  (tprinc "\\left[{")
  (do ((l (cdr mexpress) (cdr l))) ((null l) (tprinc "}\\right]"))
    (tex_engine (car l) 'mparen 'mparen)
    (when (not (lastelementp l)) (tprinc ","))))


;;	This function is a subfunction of tex-expt , tex-function and
;; tex-mqapply
(defun tex-listparen (mexpress)
  (tprinc "\\left({")
  (do ((l mexpress (cdr l))) ((null l) (tprinc "}\\right)"))
    (tex_engine (car l) 'mparen 'mparen)
    (when (not (lastelementp l)) (tprinc ","))))

;;	tex-matrix handles matrix function
(defun tex-matrix (mexpress)
  (tprinc "\\pmatrix{")
  (mapc #'(lambda (arg)
            (do ((l (cdr arg) (cdr l))) ((null l) (tprinc "\\cr "))
              (tex_engine (car l) 'mparen 'mparen)
              (when (not (lastelementp l)) (tprinc '&))))
        (cdr mexpress))
  (tprinc "}"))

(defun tex-mqapply (mexpress)
  (tex_engine (cadr mexpress) lop 'mfunction)
  (tex-listparen (cddr mexpress)))

;; this function handles the floating point number. It is adpoted from
;; RJF  .  convert 1.2e20 to 1.2 \\cdot 10^{20}
;; is it ddd.ddde+EE
; it is not. go with it as given
(defun tex-num (atom)
  (let (r firstpart exponent)
    (cond
      ((integerp atom) atom)
      (t (setq r (explode atom))
         (setq exponent (member 'e r :test #'eq))
         (cond
           ((null exponent) atom)
           (t (setq firstpart
                    (nreverse (cdr (member 'e (reverse r) :test #'eq))))
              (strcat (apply #'strcat firstpart) "\\cdot 10^{"
                      (apply #'strcat (cdr exponent)) "}")))))))

;;	this function puts parenthesis for the expression
(defun tex-paren (mexpress)
  (tprinc "\\left(")
  (tex_engine mexpress 'mparen 'mparen)
  (tprinc "\\right)"))
;;	this function handles "+" operator which is infix form
;;
;if -x or +x so call tex-function
(defun tex-plus (mexpress)
  (let ((moperands (cdr mexpress))
        (flag_trunc (member 'trunc (car mexpress) :test #'eq)))
    (cond
      ((equal (length moperands) 1) (tex-prefix mexpress))
      (t (tex_engine (car moperands) lop 'mplus)
         (print_op_oprd (cadr moperands))
         (tex-plus1 (cddr moperands) flag_trunc)))))

(defun tex-plus1 (moperands flag_trunc)
  (cond
    ((null moperands) (when flag_trunc (tprinc "+\\cdots ")))
    (t (print_op_oprd (car moperands))
       (tex-plus1 (cdr moperands) flag_trunc))))


(defun print_op_oprd (moperand)
  (cond
    ((listp moperand)
     (cond
       ((equal (caar moperand) 'mminus) (tprinc "-")
        (tex_engine (cadr moperand) 'mplus rop))
       (t (tprinc "+") (tex_engine moperand 'mplus 'mparen))))
    (t (tprinc "+") (tprinc (tex-atom moperand)))))
;;	tex-postfix handles for postfix notation expression like factorial
;;
(defun tex-postfix (mexpress)
  (tprinc "{")
  (tex_engine (cadr mexpress) lop (caar mexpress))
  (tprinc "}")
  (tprinc (getsymbol (caar mexpress))))

;;	tex-prefix is a function to handle a prefix notation form
;;
(defun tex-prefix (mexpress)
  (let ((op (caar mexpress)) (oprnd (cadr mexpress)))
    (tprinc (getsymbol op))
    (tprinc "{")
    (tex_engine oprnd op rop)
    (tprinc "}")))
;;	this function takes care the quotient function or "/" sign
;;
(defun tex-quotient (mexpress)
  (tprinc "{{")
  (tex_engine (cadr mexpress) 'mparen 'mparen)
  (tprinc "}")
  (tprinc "\\over ")
  (tprinc "{")
  (tex_engine (caddr mexpress) 'mparen 'mparen)
  (tprinc "}}"))
;;	this tex-rat is adopted from prof RJF . It performs for
;;rat function
(defun tex-rat (mexpress)
  (tprinc "{\\mathchoice ")
  (tex-quotient mexpress)
  (tex-quotient mexpress)
  (tprinc "{")
  (tex_engine (cadr mexpress) 'mparen 'mparen)
  (tprinc "//")
  (tex_engine (caddr mexpress) 'mparen 'mparen)
  (tprinc "}")
  (tprinc "{")
  (tex_engine (cadr mexpress) 'mparen 'mparen)
  (tprinc "//")
  (tex_engine (caddr mexpress) 'mparen 'mparen)
  (tprinc "}")
  (tprinc "}"))
;;	this function handle sqrt function
;;
(defun tex-sqrt (mexpress)
  (tprinc "\\sqrt{")
  (tex_engine (cadr mexpress) 'mparen 'mparen)
  (tprinc "}"))
    
;;	This function taks care both sum(exp,ind,lo,hi) and 
;; product(exp,ind,lo,hi)
;;ind
;;low
;; hi
;;exp
(defun tex-sumprod (mexpress)
  (tprinc (getsymbol (caar mexpress)))
  (tprinc "_{")
  (tex_engine (caddr mexpress) 'mparen 'mequal)
  (tprinc "=")
  (tex_engine (cadddr mexpress) 'mequal 'mparen)
  (tprinc "}")
  (tprinc "^{")
  (tex_engine (car (cddddr mexpress)) 'mparen 'mparen)
  (tprinc "}{")
  (tex_engine (cadr mexpress) 'mparen rop)
  (tprinc "}"))
;;	tex-times a function handle multiplication
(defun tex-times (mexpress)
  (let ((lop 'mtimes) (rop 'mtimes)) (tex-infix mexpress)))
(setup '(mlist (texprocess tex-list)))


(setup '(mplus (texprocess tex-plus) (tex-lbp 100) (tex-rbp 100)
               (chchr "+")))

(setup '(mminus (texprocess tex-prefix) (tex-lbp 100) (tex-rbp 100)
                (chchr "-")))

(setup '(mquote (texprocess tex-prefix) (tex-rbp 201) (chchr "'")))

(setup '(mand (texprocess tex-infix) (tex-lbp 60) (tex-rbp 60)
              (chchr "\\land ")))

(setup '(mor (texprocess tex-infix) (tex-lbp 50) (tex-rbp 50)
             (chchr "\\lor ")))

(setup '(mnot (texprocess tex-prefix) (tex-rbp 70) (chchr "\\sim ")))

(setup '(mgreaterp (texprocess tex-infix) (tex-lbp 80) (tex-rbp 80)
            (chchr >)))

(setup '(mgeqp (texprocess tex-infix) (tex-lbp 80) (tex-rbp 80)
               (chchr "\\ge ")))

(setup '(mequal (texprocess tex-infix) (tex-lbp 80) (tex-rbp 80)
                (chchr "=")))

(setup '(mnotequal (texprocess tex-infix) (tex-lbp 80) (tex-rbp 80)
            (chchr "\\ne ")))

(setup '(mleqp (texprocess tex-infix) (tex-lbp 80) (tex-rbp 80)
               (chchr "\\le ")))

(setup '(mlessp (texprocess tex-infix) (tex-lbp 80) (tex-rbp 80)
                (chchr <)))

(setup '(msetq (texprocess tex-infix) (tex-lbp 180) (tex-rbp 20)
               (chchr "\\colon ")))

(setup '(mset (texprocess tex-infix) (tex-lbp 180) (tex-rbp 20)
              (chchr "::")))

(setup '(mdefine (texprocess tex-infix) (tex-lbp 180) (tex-rbp 20)
                 (chchr ":=")))

(setup '(mfactorial (texprocess tex-postfix) (tex-lbp 160) (chchr "!")))

(setup '(mabs (texprocess tex-abs)))

(setup '(%abs (texprocess tex-abs)))

(setup '(mnctimes (texprocess tex-infix) (tex-lbp 110) (tex-rbp 109)
            (chchr "\\cdot ")))

(setup '(marrow (texprocess tex-infix) (tex-lbp 180) (tex-rbp 20)
                (chchr "\\to ")))

(setup '(mrarrow (texprocess tex-prefix) (tex-lbp 180) (tex-rbp 20)
                 (chchr "\\to ")))

(setup '(mdif (texprocess tex-infix) (tex-lbp 100) (tex-rbp 100)
              (chchr "-")))

(setup '(mtimes (texprocess tex-times) (tex-lbp 120) (tex-rbp 120)
                (chchr "\\>")))

(setup '(mdottimes (texprocess tex-infix) (tex-lbp 120) (tex-rbp 120)
            (chchr "\\cdot ")))

(setup '(mexpt (texprocess tex-expt) (tex-lbp 140) (tex-rbp 139)))

(setup '(mncexpt (texprocess tex-expt) (tex-lbp 135) (tex-rbp 134)))

(setup '(%at (texprocess tex-at)))

(setup '($at (texprocess tex-at)))

(setup '($det (texprocess tex-det)))

(setup '(%determinant (texprocess tex-det)))

(setup '($binomial (texprocess tex-binomial)))

(setup '(%binomial (texprocess tex-binomial)))

(setup '(%sum (texprocess tex-sumprod) (chchr "\\sum")))

(setup '($sum (texprocess tex-sumprod) (chchr "\\sum")))

(setup '($product (texprocess tex-sumprod) (chchr "\\prod")))

(setup '(%product (texprocess tex-sumprod) (chchr "\\prod")))

(setup '($integrate (texprocess tex-integrate) (chchr "\\int")))

(setup '(%integrate (texprocess tex-integrate) (chchr "\\int")))

(setup '($diff (texprocess tex-diff) (chchr "\\,d")))

(setup '(%derivative (texprocess tex-diff) (chchr "\\,d")))

(setup '($limit (texprocess tex-limit)))

(setup '(%limit (texprocess tex-limit)))

(setup '($sqrt (texprocess tex-sqrt) (chchr "\\sqrt ")))

(setup '(%sqrt (texprocess tex-sqrt) (chchr "\\sqrt ")))

(setup '(mquotient (texprocess tex-quotient) (tex-lbp 122)
            (tex-rbp 123) (chchr "\\over "))) 

(setup '(rat (texprocess tex-rat) (tex-lbp 120) (tex-rbp 121)))

(setup '(mconc (texprocess tex-infix) (chchr " ")))

(setup '(mparen (chchr " "))) 

(setup '(mbrak (chchr " "))) 

(setup '(mequal (texprocess tex-infix) (chchr "="))) 

(setup '(mmsubs (texprocess tex-mmsubs) (chchr "&")))

(setup '(mqapply (texprocess tex-mqapply))) 

(setup '(mmfunct (texprocess tex-funct))) 

(setup '($matrix (texprocess tex-matrix)))

(setup '($%pi (chchr "\\pi ")))

(setup '($%e (chchr "{\\rm e}")))

(setup '($%gamma (chchr "\\gamma ")))

(setup '($%phi (chchr "\\phi ")))

(setup '(& (chchr "\\&")))

(setup '(% (chchr "\\%")))

(setup '($ (chchr "\\$")))

(setup '(_ (chchr "\\_")))

(setup '($minus (chchr "-")))

(setup '($plus (chchr "+")))
;;

(setup '(mprog (chchr "{\\bf block }")))

(setup '($$block (chchr "{\\bf block }")))

(setup '($$boldif (chchr "\\bf if ")))

(setup '($$boldthen (chchr "\\bf then ")))

(setup '($$boldelse (chchr "\\bf else ")))


;;;; routines to access these fields

;;	The following are databases for special characters

(setf (get '$inf 'chchr) '"\\infty")
(setf (get '$minf 'chchr) '"-\\infty")

;;	lower case greek database

(setf (get '$alpha 'chchr) '"\\alpha")
(setf (get '%alpha 'chchr) '"\\alpha")
(setf (get '$beta 'chchr) '"\\beta")
(setf (get '$gamma 'chchr) '"\\gamma")
(setf (get '%gamma 'chchr) '"\\gamma")
(setf (get '$delta 'chchr) '"\\delta")
(setf (get '$epsilon 'chchr) '"\\epsilon")
(setf (get '$varepsilon 'chchr) '"\\varepsilon")
(setf (get '$zeta 'chchr) '"\\zeta")
(setf (get '$eta 'chchr) '"\\eta")
(setf (get '$theta 'chchr) '"\\theta")
(setf (get '$vartheta 'chchr) '"\\vartheta")
(setf (get '$iota 'chchr) '"\\iota")
(setf (get '$kappa 'chchr) '"\\kappa")
(setf (get '$lambda 'chchr) '"\\lambda")
(setf (get 'lambda 'chchr) '"\\lambda")
(setf (get '$mu 'chchr) '"\\mu")
(setf (get '$nu 'chchr) '"\\nu")
(setf (get '$xi 'chchr) '"\\xi")
(setf (get '$pi 'chchr) '"\\pi")
(setf (get '$varpi 'chchr) '"\\varpi")
(setf (get '$rho 'chchr) '"\\rho")
(setf (get '$varrho 'chchr) '"\\varrho")
(setf (get '$sigma 'chchr) '"\\sigma")
(setf (get '$varsigma 'chchr) '"\\varsigma")
(setf (get '$tau 'chchr) '"\\tau")
(setf (get '$upsilon 'chchr) '"\\upsilon")
(setf (get '$phi 'chchr) '"\\phi")
(setf (get '$varphi 'chchr) '"\\varphi")
(setf (get '$chi 'chchr) '"\\chi")
(setf (get '$psi 'chchr) '"\\psi")
(setf (get '$omega 'chchr) '"\\omega")

;;	Greek Upper Case Database

(setf (get '|$Alpha| 'chchr) '"\\Alpha")
(setf (get '|$Gamma| 'chchr) '"\\Gamma")
(setf (get '|$Delta| 'chchr) '"\\Delta")
(setf (get '|$Theta| 'chchr) '"\\Theta")
(setf (get '|$Lambda| 'chchr) '"\\Lambda")
(setf (get '|$Xi| 'chchr) '"\\Xi")
(setf (get '|$Pi| 'chchr) '"\\Pi")
(setf (get '|$Sigma| 'chchr) '"\\Sigma")
(setf (get '|$Upsilon| 'chchr) '"\\Upsilon")
(setf (get '|$Phi| 'chchr) '"\\Phi")
(setf (get '|$Psi| 'chchr) '"\\Psi")
(setf (get '|$Omega| 'chchr) '"\\Omega")
(setf (get '|$Re| 'chchr) '"\\Re")
(setf (get '|$Im| 'chchr) '"\\Im")

;;	Miscellaneous symbols

(setf (get '$aleph 'chchr) '"\\aleph")
(setf (get '$hbar 'chchr) '"\\hbar")
(setf (get '$%i 'chchr) '"\\imath")
(setf (get '$%j 'chchr) '"\\jmath")
(setf (get '$ell 'chchr) '"\\ell")
(setf (get '$wp 'chchr) '"\\wp")
(setf (get '$mho 'chchr) '"\\mho")
(setf (get '$infty 'chchr) '"\\infty")
(setf (get '$nabla 'chchr) '"\\nabla")
(setf (get '$partial 'chchr) '"\\partial")
(setf (get '$triangle 'chchr) '"\\triangle")

(setup '(%sin (texprocess tex-prefix) (tex-rbp 110) (chchr "\\sin ")))
(setup '(%cos (texprocess tex-prefix) (tex-rbp 110) (chchr "\\cos ")))
(setup '(%tan (texprocess tex-prefix) (tex-rbp 110) (chchr "\\tan ")))
(setup '(%cot (texprocess tex-prefix) (tex-rbp 110) (chchr "\\cot ")))
(setup '(%sec (texprocess tex-prefix) (tex-rbp 110) (chchr "\\sec ")))
(setup '(%csc (texprocess tex-prefix) (tex-rbp 110) (chchr "\\csc ")))

(setup '(%asin (texprocess tex-prefix) (tex-rbp 110) (chchr "\\arcsin ")))
(setup '(%acos (texprocess tex-prefix) (tex-rbp 110) (chchr "\\arccos ")))
(setup '(%atan (texprocess tex-prefix) (tex-rbp 110) (chchr "\\arctan ")))
(setup '(%acot (texprocess tex-prefix) (tex-rbp 110)
               (chchr "\\rm acot ")))
(setup '(%asec (texprocess tex-prefix) (tex-rbp 110)
               (chchr "\\rm asec ")))
(setup '(%acsc (texprocess tex-prefix) (tex-rbp 110)
               (chchr "\\rm acsc ")))
(setup '(%sinh (texprocess tex-prefix) (tex-rbp 110) (chchr "\\sinh ")))
(setup '(%cosh (texprocess tex-prefix) (tex-rbp 110) (chchr "\\cosh ")))
(setup '(%tanh (texprocess tex-prefix) (tex-rbp 110) (chchr "\\tanh ")))
(setup '(%coth (texprocess tex-prefix) (tex-rbp 110) (chchr "\\coth ")))
(setup '(%sech (texprocess tex-prefix) (tex-rbp 110) (chchr "\\sec ")))
(setup '(%csch (texprocess tex-prefix) (tex-rbp 110) (chchr "\\csch ")))

(setup '(%asinh (texprocess tex-prefix) (tex-rbp 110)
                (chchr "\\rm asinh ")))
(setup '(%acosh (texprocess tex-prefix) (tex-rbp 110)
                (chchr "\\rm acosh ")))
(setup '(%atanh (texprocess tex-prefix) (tex-rbp 110)
                (chchr "\\rm atanh ")))
(setup '(%acoth (texprocess tex-prefix) (tex-rbp 110)
                (chchr "\\rm acoth ")))
(setup '(%asech (texprocess tex-prefix) (tex-rbp 110)
                (chchr "\\rm asec ")))
(setup '(%acsch (texprocess tex-prefix) (tex-rbp 110)
                (chchr "\\rm acsch ")))

(setup '(%ln (texprocess tex-prefix) (tex-rbp 110) (chchr "\\ln ")))
(setup '(%log (texprocess tex-prefix) (tex-rbp 110) (chchr "\\log ")))

(setup '($sin (texprocess tex-prefix) (tex-rbp 110) (chchr "\\sin ")))
(setup '($cos (texprocess tex-prefix) (tex-rbp 110) (chchr "\\cos ")))
(setup '($tan (texprocess tex-prefix) (tex-rbp 110) (chchr "\\tan ")))
(setup '($cot (texprocess tex-prefix) (tex-rbp 110) (chchr "\\cot ")))
(setup '($sec (texprocess tex-prefix) (tex-rbp 110) (chchr "\\sec ")))
(setup '($csc (texprocess tex-prefix) (tex-rbp 110) (chchr "\\csc ")))

(setup '($asin (texprocess tex-prefix) (tex-rbp 110) (chchr "\\arcsin ")))
(setup '($acos (texprocess tex-prefix) (tex-rbp 110) (chchr "\\arccos ")))
(setup '($atan (texprocess tex-prefix) (tex-rbp 110) (chchr "\\arctan ")))
(setup '($acot (texprocess tex-prefix) (tex-rbp 110)
               (chchr "\\rm acot ")))
(setup '($asec (texprocess tex-prefix) (tex-rbp 110)
               (chchr "\\rm asec ")))
(setup '($acsc (texprocess tex-prefix) (tex-rbp 110)
               (chchr "\\rm acsc ")))

(setup '($sinh (texprocess tex-prefix) (tex-rbp 110) (chchr "\\sinh ")))
(setup '($cosh (texprocess tex-prefix) (tex-rbp 110) (chchr "\\cosh ")))
(setup '($tanh (texprocess tex-prefix) (tex-rbp 110) (chchr "\\tanh ")))
(setup '($coth (texprocess tex-prefix) (tex-rbp 110) (chchr "\\coth ")))
(setup '($sech (texprocess tex-prefix) (tex-rbp 110) (chchr "\\sec ")))
(setup '($csch (texprocess tex-prefix) (tex-rbp 110) (chchr "\\csch ")))

(setup '($asinh (texprocess tex-prefix) (tex-rbp 110)
                (chchr "\\rm asinh ")))
(setup '($acosh (texprocess tex-prefix) (tex-rbp 110)
                (chchr "\\rm acosh ")))
(setup '($atanh (texprocess tex-prefix) (tex-rbp 110)
                (chchr "\\rm atanh ")))
(setup '($acoth (texprocess tex-prefix) (tex-rbp 110)
                (chchr "\\rm acoth ")))
(setup '($asech (texprocess tex-prefix) (tex-rbp 110)
                (chchr "\\rm asec ")))
(setup '($acsch (texprocess tex-prefix) (tex-rbp 110)
                (chchr "\\rm acsch ")))
(setup '($ln (texprocess tex-prefix) (tex-rbp 110) (chchr "\\ln ")))
(setup '($log (texprocess tex-prefix) (tex-rbp 110) (chchr "\\log ")))


;;
;;
;;	set the preference feature
;;
($lessparen)
(setq casep nil)		;set to distinguish a capital or lower case
(setq $texworksheet nil)        ;set TeX worksheet mode false
(setq $latexworksheet nil)        ;set LaTeX worksheet mode false
(setq $texlabelleft nil)	;set Tex or LaTeX left Labeling mode false
(setq $texdisplaytype t)	;set default for TeX or LaTeX in display type
(setq $texevaluate t)	;set default for evaluating macsyma expression
(setq $texautolabel nil) ;set autolabel mode off, can be set to be integer
(setq $latexautolabel nil)	;set LaTeX autolabel mode false
