/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.automation;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.installer.panel.AbstractPanelView;
import com.izforge.izpack.installer.util.PanelHelper;

public class AutomatedPanelView
extends AbstractPanelView<PanelAutomation> {
    private final AbstractUIHandler handler;

    public AutomatedPanelView(Panel panel, ObjectFactory factory, InstallData installData, AbstractUIHandler handler) {
        super(panel, PanelAutomation.class, factory, installData);
        this.handler = handler;
    }

    public Class<PanelAutomation> getViewClass() {
        Panel panel = this.getPanel();
        return PanelHelper.getAutomatedPanel(panel.getClassName());
    }

    @Override
    protected PanelAutomation createView(Panel panel, Class<PanelAutomation> viewClass) {
        Class<PanelAutomation> impl = this.getViewClass();
        if (impl == null) {
            throw new IzPackException("Automation implementation not found for panel: " + panel.getClassName());
        }
        return this.getFactory().create(impl, panel);
    }

    @Override
    protected AbstractUIHandler getHandler() {
        return this.handler;
    }

    @Override
    protected boolean isWarningValid(String message, boolean defaultAnswer) {
        if (defaultAnswer) {
            this.handler.emitNotification(message + " - ignoring");
        } else {
            this.handler.emitError(this.getMessage("data.validation.error.title"), message);
        }
        return defaultAnswer;
    }

    @Override
    public void createInstallationRecord(IXMLElement panelRoot) {
    }
}

