/* l2xisctc.h      token codes and strings, etc for interpreter scanner etc */

/*
 * a = code enumeration
 * b = string version of code enumeration
 * c = string forming the token itself
 */

sctc(NO_TOKEN,           "NO_TOKEN",          "<no token>")
sctc(IDENTIFIER,         "IDENTIFIER",        "<IDENTIFIER>")
sctc(NUMBER_LITERAL,     "NUMBER_LITERAL",    "<NUMBER_LITERAL>")
sctc(STRING_LITERAL,     "STRING_LITERAL",    "<STRING_LITERAL>")
sctc(STAR,               "STAR",              "*")
sctc(LPAREN,             "LPAREN",            "(")
sctc(RPAREN,             "RPAREN",            ")")
sctc(MINUS,              "MINUS",             "-")
sctc(PLUS,               "PLUS",              "+")
sctc(EQUAL,              "EQUAL",             "=")
sctc(LBRACKET,           "LBRACKET",          "[")
sctc(RBRACKET,           "RBRACKET",          "]")
sctc(COLON,              "COLON",             ":")
sctc(SEMICOLON,          "SEMICOLON",         ";")
sctc(LT,                 "LT",                "<")
sctc(GT,                 "GT",                ">")
sctc(COMMA,              "COMMA",             ",")
sctc(PERIOD,             "PERIOD",            ".")
sctc(SLASH,              "SLASH",             "/")
sctc(COLONEQUAL,         "COLONEQUAL",        ":=")
sctc(LE,                 "LE",                "<=")
sctc(GE,                 "GE",                ">=")
sctc(NE,                 "NE",                "<>")
sctc(END_OF_FILE,        "END_OF_FILE",       "<END_OF_FILE>")
sctc(ERROR,              "ERROR",             "<ERROR>")
sctc(AND,                "AND",               "AND")
sctc(ARRAY,              "ARRAY",             "ARRAY")
sctc(BEGIN,              "BEGIN",             "BEGIN")
sctc(CASE,               "CASE",              "CASE")
sctc(DIV,                "DIV",               "DIV")
sctc(ELSE,               "ELSE",              "ELSE")
sctc(END,                "END",               "END")
sctc(FFILE,              "FFILE",             "FILE")
sctc(FOR,                "FOR",               "FOR")
sctc(FUNCTION,           "FUNCTION",          "FUNCTION")
sctc(IF,                 "IF",                "IF")
sctc(IN,                 "IN",                "IN")
sctc(MOD,                "MOD",               "MOD")
sctc(NOT,                "NOT",               "NOT")
sctc(OF,                 "OF",                "OF")
sctc(OR,                 "OR",                "OR")
sctc(PROCEDURE,          "PROCEDURE",         "PROCEDURE")
sctc(REPEAT,             "REPEAT",            "REPEAT")
sctc(SET,                "SET",               "SET")
sctc(THEN,               "THEN",              "THEN")
sctc(TO,                 "TO",                "TO")
sctc(TYPE,               "TYPE",              "TYPE")
sctc(UNTIL,              "UNTIL",             "UNTIL")
sctc(VAR,                "VAR",               "VAR")
sctc(WHILE,              "WHILE",             "WHILE")
sctc(WITH,               "WITH",              "WITH")
sctc(ENDCODE,            "END_CODE",          "END_CODE")
sctc(END_OF_STATEMENTS,  "END_OF_STATEMENTS", "<END_OF_STATEMENTS>")
sctc(THE_DAY,            "THE_DAY",           "THE_DAY")
sctc(THE_MONTH,          "THE_MONTH",         "THE_MONTH")
sctc(THE_YEAR,           "THE_YEAR",          "THE_YEAR")
sctc(BACKSLASH,          "BACKSLASH",         "\\")
sctc(BAR,                "BAR",               "|")
sctc(BARBAR,             "BARBAR",            "||")
sctc(COLONEQUALCOLON,    "COLONEQUALCOLON",   ":=:")
sctc(COLONNEQCOLON,      "COLONNEQCOLON",     ":<>:")
sctc(COMMERCIAL_AT,      "COMMERCIAL_AT",     "@")
sctc(DOUBLEQUOTE,        "DOUBLEQUOTE",       "\"")
sctc(EQUALEQUAL,         "EQUALEQUAL",        "==")
sctc(EXCLAMATION,        "EXCLAMATION",       "!")
sctc(LBRACE,             "LBRACE",            "{")
sctc(LTMINUS,            "LTMINUS",           "<-")
sctc(MINUSGT,            "MINUSGT",           "->")
sctc(MINUSMINUS,         "MINUSMINUS",        "--")
sctc(PARENSTAR,          "PARENSTAR",         "(*")
sctc(PERCENT,            "PERCENT",           "%")
sctc(QUERY_CHAR,         "QUERY_CHAR",        "?")
sctc(RBRACE,             "RBRACE",            "}")
sctc(STARPAREN,          "STARPAREN",         "*)")
sctc(STARSTAR,           "STARSTAR",          "**")
sctc(XABSTRACT,          "XABSTRACT",         "ABSTRACT")
sctc(XAGGREGATE,         "XAGGREGATE",        "AGGREGATE")
sctc(XALIAS,             "XALIAS",            "ALIAS")
sctc(XAS,                "XAS",               "AS")
sctc(XBAG,               "XBAG",              "BAG")
sctc(XBINARY,            "XBINARY",           "BINARY")
sctc(XBOOLEAN,           "XBOOLEAN",          "BOOLEAN")
sctc(XBY,                "XBY",               "BY")
sctc(XCONSTANT,          "XCONSTANT",         "CONSTANT")
sctc(XCONTEXT,           "XCONTEXT",          "CONTEXT")
sctc(XDERIVE,            "XDERIVE",           "DERIVE")
sctc(XEND_ALIAS,         "XEND_ALIAS",        "END_ALIAS")
sctc(XEND_CASE,          "XEND_CASE",         "END_CASE")
sctc(XEND_CONSTANT,      "XEND_CONSTANT",     "END_CONSTANT")
sctc(XEND_CONTEXT,       "XEND_CONTEXT",      "END_CONTEXT")
sctc(XEND_ENTITY,        "XEND_ENTITY",       "END_ENTITY")
sctc(XEND_FUNCTION,      "XEND_FUNCTION",     "END_FUNCTION")
sctc(XEND_IF,            "XEND_IF",           "END_IF")
sctc(XEND_LOCAL,         "XEND_LOCAL",        "END_LOCAL")
sctc(XEND_MODEL,         "XEND_MODEL",        "END_MODEL")
sctc(XEND_PROCEDURE,     "XEND_PROCEDURE",    "END_PROCEDURE")
sctc(XEND_REPEAT,        "XEND_REPEAT",       "END_REPEAT")
sctc(XEND_RULE,          "XEND_RULE",         "END_RULE")
sctc(XEND_SCHEMA,        "XEND_SCHEMA",       "END_SCHEMA")
sctc(XEND_TYPE,          "XEND_TYPE",         "END_TYPE")
sctc(XENTITY,            "XENTITY",           "ENTITY")
sctc(XENUMERATION,       "XENUMERATION",      "ENUMERATION")
sctc(XESCAPE,            "XESCAPE",           "ESCAPE")
sctc(XFIXED,             "XFIXED",            "FIXED")
sctc(XFROM,              "XFROM",             "FROM")
sctc(XGENERIC,           "XGENERIC",          "GENERIC")
sctc(XINTEGER,           "XINTEGER",          "INTEGER")
sctc(XINVERSE,           "XINVERSE",          "INVERSE")
sctc(XLIST,              "XLIST",             "LIST")
sctc(XLOCAL,             "XLOCAL",            "LOCAL")
sctc(XLOGICAL,           "XLOGICAL",          "LOGICAL")
sctc(XMODEL,             "XMODEL",            "MODEL")
sctc(XNUMBER,            "XNUMBER",           "NUMBER")
sctc(XONEOF,             "XONEOF",            "ONEOF")
sctc(XOPTIONAL,          "XOPTIONAL",         "OPTIONAL")
sctc(XOTHERWISE,         "XOTHERWISE",        "OTHERWISE")
sctc(XQUERY,             "XQUERY",            "QUERY")
sctc(XREAL,              "XREAL",             "REAL")
sctc(XREFERENCE,         "XREFERENCE",        "REFERENCE")
sctc(XRETURN,            "XRETURN",           "RETURN")
sctc(XRULE,              "XRULE",             "RULE")
sctc(XSCHEMA,            "XSCHEMA",           "SCHEMA")
sctc(XSELECT,            "XSELECT",           "SELECT")
sctc(XSKIP,              "XSKIP",             "SKIP")
sctc(XSTRING,            "XSTRING",           "STRING")
sctc(XSUBTYPE,           "XSUBTYPE",          "SUBTYPE")
sctc(XSUPERTYPE,         "XSUPERTYPE",        "SUPERTYPE")
sctc(XUNIQUE,            "XUNIQUE",           "UNIQUE")
sctc(XUSE,               "XUSE",              "USE")
sctc(XWHERE,             "XWHERE",            "WHERE")
sctc(XANDOR,             "XANDOR",            "ANDOR")
sctc(XLIKE,              "XLIKE",             "LIKE")
sctc(XXOR,               "XXOR",              "XOR")
sctc(XSELF,              "XSELF",             "SELF")
sctc(XCONST_E,           "XCONST_E",          "CONST_E")
sctc(XPI,                "XPI",               "PI")
sctc(XFALSE,             "XFALSE",            "FALSE")
sctc(XTRUE,              "XTRUE",             "TRUE")
sctc(XUNKNOWN,           "XUNKNOWN",          "UNKNOWN")
sctc(XCALL,              "XCALL",             "CALL")
sctc(XCRITERIA,          "XCRITERIA",         "CRITERIA")
sctc(XEND_CALL,          "XEND_CALL",         "END_CALL")
sctc(XEND_CRITERIA,      "XEND_CRITERIA",     "END_CRITERIA")
sctc(XEND_NOTES,         "XEND_NOTES",        "END_NOTES")
sctc(XEND_OBJECTIVE,     "XEND_OBJECTIVE",    "END_OBJECTIVE")
sctc(XEND_PARAMETER,     "XEND_PARAMETER",    "END_PARAMETER")
sctc(XEND_PURPOSE,       "XEND_PURPOSE",      "END_PURPOSE")
sctc(XEND_REALIZATION,   "XEND_REALIZATION",  "END_REALIZATION")
sctc(XEND_REFERENCES,    "XEND_REFERENCES",   "END_REFERENCES")
sctc(XEND_SCHEMA_DATA,   "XEND_SCHEMA_DATA",  "END_SCHEMA_DATA")
sctc(XEND_TEST_CASE,     "XEND_TEST_CASE",    "END_TEST_CASE")
sctc(XIMPORT,            "XIMPORT",           "IMPORT")
sctc(XNOTES,             "XNOTES",            "NOTES")
sctc(XOBJECTIVE,         "XOBJECTIVE",        "OBJECTIVE")
sctc(XPARAMETER,         "XPARAMETER",        "PARAMETER")
sctc(XPURPOSE,           "XPURPOSE",          "PURPOSE") 
sctc(XREALIZATION,       "XREALIZATION",      "REALIZATION")
sctc(XREFERENCES,        "XREFERENCES",       "REFERENCES")
sctc(XSCHEMA_DATA,       "XSCHEMA_DATA",      "SCHEMA_DATA")
sctc(XSUBOF,             "XSUBOF",            "SUBOF")
sctc(XSUPOF,             "XSUPOF",            "SUPOF")
sctc(XTEST_CASE,         "XTEST_CASE",        "TEST_CASE")
sctc(XUSING,             "XUSING",            "USING")
sctc(EOTC,               "EOTC",              "<EOTC>")    /* this and the following must always be the last */
sctc(STATEMENT_MARKER,   "STATEMENT_MARKER",  "<STATEMENT_MARKER>")
sctc(ADDRESS_MARKER,     "ADDRESS_MARKER",    "<ADDRESS_MARKER>")
