/* l2xiscan.h  for LTX2X interpreter scanner */

#ifndef scanner_h
#define scanner_h

#include "l2xicmon.h"

/* token codes */

typedef enum {
#define sctc(a, b, c) a,
#include "l2xisctc.h"
#undef sctc
} TOKEN_CODE;


/* literal structure */
typedef enum {
  INTEGER_LIT,
  REAL_LIT,
  STRING_LIT,
} LITERAL_TYPE;

typedef struct {
  LITERAL_TYPE type;
  union {
    XPRSAINT integer;
    XPRSAREAL real;
    char string[MAX_SOURCE_LINE_LENGTH];
  } value;
} LITERAL;

/* functions */
BOOLEAN token_in();

#endif
